% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_data.R
\name{extractData}
\alias{extractData}
\title{Datasets dfData, mData, tData, xData, zData, extractData : extractData}
\usage{
extractData(pr = "p", ft = "tss", start = "2007-01-01",
  end = "2013-12-31")
}
\arguments{
\item{pr}{character. Extract prices or returns: \code{c("p","r","prices","returns")}.}

\item{ft}{character. Output format among \code{c("tss","xts","zoo","dfr","bfr","mat")}.}

\item{start}{character. Start date.}

\item{end}{character. End date.}
}
\description{
dfData, mData, tData, xData, zData are datasets made of lists of data.frame, matrix, 
timeSeries, xts and zoo components. They describe prices and returns of 10 financial series
used in the documents and demos presented at 8th and 9th R/Rmetrics conferences  
(2014, 2015). See the references. 
The last serie (CHF, interest rates in Switzerland) exhibits negative prices. 
All distributions of logreturns exhibit fat tails.
Function \code{extractData} converts subsets of mData, tData, xData, zData.
}
\details{
10 financial series presented in four different formats for convenient use: 
dfData is the complete dataset in data.frame format with dates as row.names 
and one or several columns. 
tData, xData and zData are lists of timeSeries, xts and zoo formats 
and display only one column per stock. 
\enumerate{
  \item{ "GOLD" from 1999-01-04 to 2013-12-31, dim 3694x1 (df, m, t, x, z). }
  \item{ "DEXIA" from 2008-10-27 to 20009-10-26, dim 255x1 (t, x, z), 255x5 (df). }
  \item{ "SOCGEN" from 1992-07-20 to 2013-12-31, dim 5445x1 (m, t, x, z), 5445x5 (df). }
  \item{ "VIVENDI" from 1992-07-20 to 2013-12-31, dim 5444x1 (m, t, x, z) 5444x5 (df). }
  \item{ "EURUSD" from 1999-01-03 to 2013-12-31, dim 3843x1 (m, t, x, z), 3843x4 (df). }
  \item{ "VIX" from 2004-01-02 to 2013-12-31, dim 2517x1 (m, t, x, z), 2517x4 (df). }
  \item{ "CAC40" from 1988-01-04 to 2013-12-31, dim 6574x1 (m, t, x, z), 6574x4 (df). }
  \item{ "DJIA" from 1896-05-26 to 2013-12-31, dim 32064x1 (m, df, t, x, z). }
  \item{ "SP500" from 1957-01-02 to 2013-12-31, dim 14350x1 (m, df, t, x, z). }
  \item{ "CHF" from 1995-01-02 to 2013-09-13, dim 4880x1 (t, x, z), 4880x8 (df). 
            Interst rates in Switzerland. Include negative prices at the end 
            of the dataset. Care is required to calculate the returns! 
            (Use \code{\link{fatreturns}} and \code{\link{elevate}}). 
            See the examples if you decide or need to remove it from the list.}
}

Function \code{extractData} extracts 8 financial series from matrix mData 
(DEXIA and CHF are not included) and converts them into a 2 dimensions object 
with any of the following class:
\itemize{
  \item{ "tss" is for timeSeries with a timeDate index. }
  \item{ "xts" is for xts with a POSIXct index. }
  \item{ "zoo" is for zoo with a Date index. }
  \item{ "dfr" is the usual R data.frame with the Date as index. }
  \item{ "bfr" is a data.frame with the Date in the first column. }
  \item{ "mat" is a matrix with the Date in the rownames. }
}
The \code{start} date must be posterior to "2007-01-01" (default) and the 
\code{end} date must be anterior to "2013-12-31" (default).
}
\examples{
   

library(zoo) 
library(xts) 
library(timeSeries) 

### dfData, tData, xData, zData : prices only
attributes(dfData); attributes(tData); attributes(xData); attributes(zData) 
lapply(dfData, head, 3)
lapply( mData, head, 3)
lapply( tData, head, 3)
lapply( xData, head, 3)
lapply( zData, head, 3)

### extractData : prices and logreturns
head(ptD <- extractData("p", "tss", "2009-01-01", "2012-12-31")) ; tail(ptD)
head(rtD <- extractData("r", "tss")) 
head(pxD <- extractData("p", "xts")) 
head(rxD <- extractData("r", "xts")) 
head(pzD <- extractData("p", "zoo")) 
head(rzD <- extractData("r", "zoo")) 
head(pbD <- extractData("p", "bfr")) 
head(rbD <- extractData("r", "bfr")) 
head(pmD <- extractData("p", "mat")) 
head(rmD <- extractData("r", "mat")) 

### Remove item CHF (negative prices) from dfData, tData, xData, zData
Z <- dfData[names(dfData)[1:9]]; attributes(Z)
Z <- tData[names(tData)[1:9]]; attributes(Z)
Z <- xData[names(xData)[1:9]]; attributes(Z)
Z <- zData[names(zData)[1:9]]; attributes(Z)

}
\references{
P. Kiener, Explicit models for bilateral fat-tailed distributions and 
applications in finance with the package FatTailsR, 8th R/Rmetrics Workshop 
and Summer School, Paris, 27 June 2014. Download it from: 
\url{http://www.inmodelia.com/exemples/2014-0627-Rmetrics-Kiener-en.pdf}

P. Kiener, Fat tail analysis and package FatTailsR, 
9th R/Rmetrics Workshop and Summer School, Zurich, 27 June 2015. 
\url{http://www.inmodelia.com/exemples/2015-0627-Rmetrics-Kiener-en.pdf}
}
\seealso{
\code{\link{tData}}, \code{\link{xData}}, \code{\link{zData}}, \code{\link{dfData}},
\code{\link{getDSdata}}.
}
