% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/test.R
\name{test}
\alias{test}
\title{Bootstrap based test for covariate selection}
\usage{
test(x, y, method = "lm", family = "gaussian", nboot = 50,
  speedup = TRUE, qmin = NULL, unique = FALSE, q = NULL,
  bootseed = NULL, cluster = TRUE, ncores = NULL)
}
\arguments{
\item{x}{A data frame containing all the covariates.}

\item{y}{A vector with the response values.}

\item{method}{A character string specifying which regression method is used,
i.e., linear models (\code{"lm"}), generalized additive models.}

\item{family}{A description of the error distribution and link function to be
used in the model: (\code{"gaussian"}), (\code{"binomial"}) or
(\code{"poisson"}).}

\item{nboot}{Number of bootstrap repeats.}

\item{speedup}{A logical value. If  \code{TRUE} (default), the testing procedure
is  computationally efficient since it considers one more variable to fit
the alternative model than the number of variables used to fit the null.
If \code{FALSE}, the fit of the alternative model is based on considering
the best subset of variables of size greater than \code{q}, the one that minimizes an
information criterion. The size of this subset must be given by the user
filling the argument \code{qmin}.}

\item{qmin}{By default \code{NULL}. If \code{speedup} is \code{FALSE},
\code{qmin} is an integer number selected by the user. To help you select
this argument, it is recommended to visualize the graphical output of the
\code{plot} function and choose the number \code{q} which minimizes the curve.}

\item{unique}{A logical value. By default \code{FALSE}. If  \code{TRUE},
the test is performed only for one null hypothesis, given by the argument  \code{q}.}

\item{q}{By default \code{NULL}. If  \code{unique} is \code{TRUE}, \code{q}
is the size of the subset of variables to be tested.}

\item{bootseed}{Seed to be used in the bootstrap procedure.}

\item{cluster}{A logical value. If  \code{TRUE} (default), the testing
procedure is  parallelized.}

\item{ncores}{An integer value specifying the number of cores to be used
in the parallelized procedure. If \code{NULL} (default), the number of cores to be used
is equal to the number of cores of the machine - 1.}
}
\value{
\item{Hypothesis}{Number of the null hypothesis tested}
 \item{Statistic}{Value of the T statistic} \item{pvalue}{pvalue obtained in
 the testing procedure} \item{Decision}{Result of the test for a significance
 level of 0.05}
}
\description{
Function that applies a bootstrap based test for covariate
 selection. It helps to determine the number of variables to be included in
 the model.
}
\details{
In a regression framework, let \eqn{X_1, X_2, \ldots, X_p},  a set of
 \eqn{p} initial variables and \eqn{Y} the response variable, we propose a
 procedure to test the null hypothesis of \eqn{q} significant variables  in
 the model --\eqn{q}  effects not equal to zero-- versus the alternative in
 which the model contains more than \eqn{q} variables. Based on the general
 model \deqn{Y=m(\textbf{X})+\varepsilon  \quad {\rm{where}} \quad
 m(\textbf{X})= m_{1}(X_{1})+m_{2}(X_{2})+\ldots+m_{p}(X_{p})} the following
 strategy is considered: for a subset of size \eqn{q}, considerations will be
 given to a test for the null hypothesis \deqn{H_{0} (q): \sum_{j=1}^p
 I_{\{m_j \ne 0\}} \le q} vs. the general hypothesis \deqn{H_{1} :
 \sum_{j=1}^p I_{\{m_j \ne 0\}} > q}
}
\note{
The detailed expression of the formulas are described in HTML help
 \url{http://cran.r-project.org/web/packages/FWDselect/FWDselect.pdf}
}
\examples{
library(FWDselect)
data(diabetes)
x = diabetes[ ,2:11]
y = diabetes[ ,1]
test(x, y, method = "lm", cluster = FALSE, nboot = 5)

# for speedup = FALSE
obj2 = qselection(x, y, qvector = c(1:9), method = "lm",
 cluster = FALSE)
plot(obj2) # we choose q = 7 for the argument qmin
test(x, y, method = "lm", cluster = FALSE, nboot = 5,
speedup = FALSE, qmin = 7)
}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
\references{
Sestelo, M., Villanueva, N. M. and Roca-Pardinas, J. (2013).
 FWDselect: an R package for selecting variables in regression models.
 Discussion Papers in Statistics and Operation Research, University of Vigo, 13/01.
}
\seealso{
\code{\link{selection}}
}

