% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.ftrlprox.r
\name{initialize.ftrlprox}
\alias{initialize.ftrlprox}
\title{Initialize empty FTRL Proximal class}
\usage{
initialize.ftrlprox(theta, levels, lambda1, lambda2, a, b = 1,
  save_loss = F, ...)
}
\arguments{
\item{theta}{named numeric containing initial coefficients}

\item{levels}{character vector containing class labels of target label}

\item{lambda1}{L1 regularization term}

\item{lambda2}{L2 regularization term}

\item{a}{learning rate parameter}

\item{b}{learning rate parameter controlling decay, defaults to 1.}

\item{save_loss}{is to save the loss function during training.}

\item{...}{additional args}
}
\value{
ftrlprox model object
}
\description{
Online elastic net regression using the FTRL Proximal algorithm for training.
}
\details{
This method is intended for setting up a ftrlprox model object before training it using update.
}
\author{
Vilhelm von Ehrenheim
}

