% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequentialSelection.R
\name{sequentialFloatingForwardSelection}
\alias{sequentialFloatingForwardSelection}
\title{Sequential Floating Forward Selection}
\usage{
sequentialFloatingForwardSelection()
}
\value{
Returns a search function that is used to guide the feature selection process.
}
\description{
Generates a search function based on sequential floating forward selection. This function is called internally within the \code{\link{searchAlgorithm}} function. The sffs method \insertCite{Pudil1994}{FSinR} starts with an empty set of features and add a single feature at each step with a view to improving the evaluation of the set. In addition, it checks whether removing any of the included features, improve the value of the set.
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a search process in a feature space
## Classification problem

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('determinationCoefficient')

# Generates the search function with sffs
sffs_search <- sequentialFloatingForwardSelection()
# Performs the search process directly (parameters: dataset, target variable and evaluator)
sffs_search(iris, 'Species', filter_evaluator)
}
}
\references{
\insertAllCited{}
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
