% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectThreshold}
\alias{selectThreshold}
\title{Select threshold}
\usage{
selectThreshold(data, class, featureEval, threshold = 0.5)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureEval}{\itemize{
\item The measure used to evaluate features
}}

\item{threshold}{\itemize{
\item Number between 0 and 1
}}
}
\value{
A list is returned containing:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{featuresSelected}{The names of the returned features sorted according to the result of the evaluation measure}
\item{valuePerFeature}{The evaluation measures of the returned features}
}
}
\description{
Selects the features whose evaluation is over/under a user given threshold (It depends on the method that generates the evaluation measure. For example: under for regression methods, over for classification methods, etc.). Features that do not satisfy the threshold, will be removed
}
\examples{
## Select Threshold for iris dataset (filter method)
# Features with a evaluation measure higher than 0.7
selectThreshold(iris, 'Species', mutualInformation, 0.7) 
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
