% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/YTFlounder.R
\docType{data}
\name{YTFlounder}
\alias{YTFlounder}
\title{Ages of Yellowtail Flounder assigned from scales and otoliths.}
\format{
A data frame with 27 paired observations on the following 3 variables.
 \describe{
   \item{scale}{Ages assigned from scales}
   \item{whole}{Ages assigned from whole otoliths} 
   \item{cross}{Ages assigned from cross-sections of otoliths} 
 }
}
\source{
From tables in Annex 3 of Walsh, S.J. and J. Burnett. 2002. The Canada-United States yellowtail flounder age reading workshop: 28-30 November 2000, St. John's, Newfoundland. North Atlantic Fisheries Organization. Scientific Council Studies 35:1-59.
}
\description{
Ages of commercially caught Georges Bank Yellowtail Flounder (\emph{Limanda ferruginea}) as determined by scales, whole otoliths, or otolith cross-sections.
}
\section{Topic(s)}{

 \itemize{
   \item Age Comparison 
   \item Age Precision 
   \item Age Bias
   \item Ageing Error
 }
}

\examples{
data(YTFlounder)
str(YTFlounder)
head(YTFlounder)
op <- par(mfrow=c(2,2),pch=19)
plot(scale~whole,data=YTFlounder)
plot(scale~cross,data=YTFlounder)
plot(whole~cross,data=YTFlounder)
par(op)

}
\concept{Age Bias}
\concept{Age Comparison}
\concept{Age Precision}
\keyword{datasets}
