% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alkSummaries.R
\name{alkAgeDist}
\alias{alkAgeDist}
\title{Proportions-at-age from an Age-Length Key}
\usage{
alkAgeDist(key, lenA.n, len.n)
}
\arguments{
\item{key}{A numeric matrix that contains the age-length key.  See details.}

\item{lenA.n}{A numeric vector of sample sizes for each length interval in the \emph{aged sample}.}

\item{len.n}{A numeric vector of sample sizes for each length interval in the \emph{complete sample} (i.e., all fish regardless of whether they were aged or not).}
}
\value{
A data.frame with as many rows as ages (columns) present in \code{key} and the following three variables:
\itemize{
  \item age The ages.
  \item prop The proportion of fish at each age.
  \item se The SE for the proportion of fish at each age.
 }
}
\description{
Computes the proportions-at-age (with standard errors) in a larger sample based on an age-length-key created from a subsample of ages through a two-stage random sampling design.  Follows the methods in Quinn and Deriso (1999).
}
\details{
The age-length key in \code{key} must have length intervals as rows and ages as columns.  The row names of \code{key} (i.e., \code{rownames(key)}) must contain the mininum values of each length interval (e.g., if an interval is 100-109 then the corresponding row name must be 100).  The column names of \code{key} (i.e., \code{colnames(key)}) must contain the age values (e.g., the columns can NOT be named with \dQuote{age.1}, for example).

The length intervals in the rows of \code{key} must contain all of the length intervals present in the larger sample.  Thus, the length of \code{len.n} must, at least, equal the number of rows in \code{key}.  If this constraint is not met, then the function will stop with an error message.

The values in \code{lenA.n} are equal to what the row sums of \code{key} would have been before \code{key} was converted to a row proportions table.  Thus, the length of \code{lenA.n} must also be equal to the number of rows in \code{key}.  If this constraint is not met, then the function will stop with an error message.
}
\section{Testing}{
 The results from this function perfectly match the results in Table 8.4 (left) of Quinn and Deriso (1999) using \code{\link[FSAdata]{SnapperHG2}} from \pkg{FSAdata}.  The results also perfectly match the results from using \code{\link[fishmethods]{alkprop}} in \pkg{fishmethods}.
}

\section{IFAR Chapter}{
 5-Age-Length Key.
}
\examples{
## Get data with length measurements and some assigned ages
data(WR79)

## Example -- Even breaks for length categories
WR1 <- WR79
# add length intervals (width=5)
WR1$LCat <- lencat(WR1$len,w=5)
# get number of fish in each length interval in the entire sample
len.n <- xtabs(~LCat,data=WR1)
# isolate aged sample and get number in each length interval
WR1.age <- subset(WR1, !is.na(age))
lenA.n <- xtabs(~LCat,data=WR1.age)
# create age-length key
raw <- xtabs(~LCat+age,data=WR1.age)
( WR1.key <- prop.table(raw, margin=1) )

# use age-length key to estimate age distribution of all fish
alkAgeDist(WR1.key,lenA.n,len.n)

}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\references{
Ogle, D.H.  2015.  \href{http://derekogle.com/IFAR}{Introductory Fisheries Analyses with R}.  Chapman & Hall/CRC, Boca Raton, FL.

Lai, H.-L.  1987.  Optimum allocation for estimating age composition using age-length key. Fishery Bulletin, 85:179-185.

Lai, H.-L.  1993.  Optimum sampling design for using the age-length key to estimate age composition of a fish population. Fishery Bulletin, 92:382-388.

Quinn, T. J. and R. B. Deriso. 1999. Quantitative Fish Dynamics. Oxford University Press, New York, New York. 542 pages.
}
\seealso{
See \code{\link{alkIndivAge}} and related functions for a completely different methodology.  See \code{\link[fishmethods]{alkprop}} from \pkg{fishmethods} for the exact same methodology but with a different format for the inputs.
}
\keyword{manip}

