% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/residPlot.R
\name{residPlot}
\alias{residPlot}
\alias{residPlot.IVR}
\alias{residPlot.ONEWAY}
\alias{residPlot.POLY}
\alias{residPlot.SLR}
\alias{residPlot.TWOWAY}
\alias{residPlot.lm}
\alias{residPlot.nlme}
\alias{residPlot.nls}
\title{Construct a residual plot from lm or nls objects.}
\usage{
residPlot(object, ...)

\method{residPlot}{lm}(object, ...)

\method{residPlot}{SLR}(object, xlab = "Fitted Values", ylab = "Residuals",
  main = NULL, pch = 16, col = "black", lty.ref = 3, lwd.ref = 1,
  col.ref = "black", resid.type = c("raw", "standardized", "studentized"),
  outlier.test = TRUE, alpha = 0.05, loess = TRUE, lty.loess = 2,
  lwd.loess = 1, col.loess = "black", trans.loess = 4, inclHist = TRUE,
  ...)

\method{residPlot}{POLY}(object, ...)

\method{residPlot}{IVR}(object, xlab = "Fitted Values", ylab = "Residuals",
  main = NULL, pch = c(16, 21, 15, 22, 17, 24, c(3:14)), col = "rich",
  lty.ref = 3, lwd.ref = 1, col.ref = "black", resid.type = c("raw",
  "standardized", "studentized"), outlier.test = TRUE, alpha = 0.05,
  loess = TRUE, lty.loess = 2, lwd.loess = 1, col.loess = "black",
  trans.loess = 4, legend = "topright", inclHist = TRUE, ...)

\method{residPlot}{ONEWAY}(object, xlab = "Fitted Values",
  ylab = "Residuals", main = NULL, pch = 16, col = "black",
  lty.ref = 3, lwd.ref = 1, col.ref = "black", resid.type = c("raw",
  "standardized", "studentized"), bp = TRUE, outlier.test = TRUE,
  alpha = 0.05, loess = TRUE, lty.loess = 2, lwd.loess = 1,
  col.loess = "black", trans.loess = 4, inclHist = TRUE, ...)

\method{residPlot}{TWOWAY}(object, xlab = "Fitted Values",
  ylab = "Residuals", main = NULL, pch = 16, col = "black",
  lty.ref = 3, lwd.ref = 1, col.ref = "black", resid.type = c("raw",
  "standardized", "studentized"), bp = TRUE, outlier.test = TRUE,
  alpha = 0.05, loess = TRUE, lty.loess = 2, lwd.loess = 1,
  col.loess = "black", trans.loess = 4, inclHist = TRUE, ...)

\method{residPlot}{nls}(object, xlab = "Fitted Values", ylab = "Residuals",
  main = "", pch = 16, col = "black", lty.ref = 3, lwd.ref = 1,
  col.ref = "black", resid.type = c("raw", "standardized", "studentized"),
  loess = TRUE, lty.loess = 2, lwd.loess = 1, col.loess = "black",
  trans.loess = 4, inclHist = TRUE, ...)

\method{residPlot}{nlme}(object, xlab = "Fitted Values", ylab = "Residuals",
  main = "", pch = 16, col = "black", lty.ref = 3, lwd.ref = 1,
  col.ref = "black", resid.type = c("raw", "standardized", "studentized"),
  loess = TRUE, lty.loess = 2, lwd.loess = 1, col.loess = "black",
  trans.loess = 4, inclHist = TRUE, ...)
}
\arguments{
\item{object}{An \code{lm} or \code{nls} object (i.e., returned from fitting a model with either \code{lm} or \code{nls}).}

\item{xlab}{A string for labelling the x-axis.}

\item{ylab}{A string for labelling the y-axis.}

\item{main}{A string for the main label to the plot.  Defaults to the model call.}

\item{pch}{A numeric that indicates the plotting charachter to be used or a vector of numerics that indicates what plotting charachters codes to use for the levels of the second factor.  See \code{par}.}

\item{col}{A vector of color names that indicates what color of points and lines to use for the levels of the first factor.  See \code{par}.}

\item{lty.ref}{A numeric that indicates the line type to use for the reference line at residual=0.  See \code{par}.}

\item{lwd.ref}{A numeric that indicates the line width to use for the reference line at residual=0.  See \code{par}.}

\item{col.ref}{A numeric or character that indicates the line color to use for the reference line at residual=0.  See \code{par}.}

\item{resid.type}{The type of residual to use.  \sQuote{Raw} residuals are used by default.  See details.}

\item{outlier.test}{A logical that indicates if an \code{outlierTest} will \code{TRUE} (default) be performed and if the indivdiual with the largest studentized residual is deemed to be a significant outlier it will be noted on the residual plot by its observation number.}

\item{alpha}{A numeric that indicates the alpha level to use for the outlier test (only used if \code{outlier.test=TRUE}).}

\item{loess}{A logical that indicates if a loess smoother line and approximate confidence interval band is fit to and shown on the residual plot (\code{TRUE}).}

\item{lty.loess}{A numeric that indicates the line type to use for loess fit line.  See \code{par}.}

\item{lwd.loess}{A numeric that indicates the line width to use for loess fit line.  See \code{par}.}

\item{col.loess}{A numeric or character that indicates the line color to use for loess fit line.  See \code{par}.}

\item{trans.loess}{A single numeric that indicates how transparent the loess band should be (larger numbers are more transparent).}

\item{inclHist}{A logical that indicates if a second pane that includes the histogram of residuals should be constructed.}

\item{legend}{If \code{TRUE}, draw a legend and the user must click in the upper-left corner of where the legend should be placed; if \code{FALSE} do not draw a legend.  If a vector of length 2 then draw the upper left corner of the legend at the coordinates given in the vector of length 2.}

\item{bp}{A logical that indicates if the plot for the one-way and two-way ANOVA will be a boxplot (\code{TRUE}; default) or not.}

\item{\dots}{Other arguments to the generic \code{plot} function.}
}
\value{
None.  However, a residual plot is produced.
}
\description{
Constructs a residual plot for \code{lm} or \code{nls} objects.  Different symbols for different groups can be added to the plot if an indicator variable regression is used.
}
\details{
If the user chooses to add a legend without identifying coordinates for the upper-left corner of the legend (i.e., \code{legend=TRUE}) then the R console is suspended until the user places the legend by clicking on the produced graphic at the point where the upper-left corner of the legend should appear.  A legend will only be placed if the \code{mdl} is an indicator variable regression, even if \code{legend=TRUE}.

Three types of residuals are allowed for most model types.  Raw residuals are simply the difference between the observed response variable and the predicted/fitted value.  Standardized residuals are internally studentized residuals returned by \code{\link{rstandard}} for linear models and are the raw residual divided by the standard deviation of the residuals for nonlinear models (as is done by \code{\link[nlstools]{nlsResiduals}} from \pkg{nlstools}).  Studentized residuals are the externally studentized residuals returned by \code{\link{rstudent}} for linear models and are not available for nonlinear models.

Externally Studentized residuals are not supported for \code{nls} or \code{nlme} objects.  The

If \code{outlier.test=TRUE} then significant outliers are detected with \code{\link[car]{outlierTest}} from the \pkg{car} package.  See the help for this function for more details.
}
\note{
This function is meant to allow newbie students the ability to easily construct residual plots for one-way ANOVA, two-way ANOVA, simple linear regression, and indicator variable regressions.  The plots can be constructed by submitting a saved linear model to this function which allows students to interact with and visualize moderately complex linear models in a fairly easy and efficient manner.
}
\examples{
data(Mirex)
Mirex$year <- factor(Mirex$year)

## Indicator variable regression with two factors
lm1 <- lm(mirex~weight*year*species,data=Mirex)
# defaults
residPlot(lm1)
# remove the histogram
residPlot(lm1,inclHist=FALSE)
# remove the loess line
residPlot(lm1,loess=FALSE,inclHist=FALSE)
# modify colors used
residPlot(lm1,col="rainbow",inclHist=FALSE)
# use only one point type -- notice that all points are of same type
residPlot(lm1,pch=16,inclHist=FALSE)
# use only one point and one color (might as well not use legend also)
residPlot(lm1,pch=16,col="black",legend=FALSE,inclHist=FALSE)
# can accomplish same thing just by removing the legend
residPlot(lm1,legend=FALSE,inclHist=FALSE)
# modify the reference line
residPlot(lm1,col.ref="blue",lwd.ref=5,inclHist=FALSE)
# use Studentized residuals
residPlot(lm1,resid.type="studentized",inclHist=FALSE)
# use Standardized residuals
residPlot(lm1,resid.type="standardized",inclHist=FALSE)

## Indicator variable regression with same two factors but in different order
##   (notice use of colors and symbols)
lm1a <- lm(mirex~weight*species*year,data=Mirex)
residPlot(lm1a)

## Indicator variable regression with only one factor
lm2 <- lm(mirex~weight*year,data=Mirex)
residPlot(lm2)

## Indicator variable regression (assuming same slope)
lm3 <- lm(mirex~weight+year,data=Mirex)
residPlot(lm3)

## Simple linear regression
lm4 <- lm(mirex~weight,data=Mirex)
residPlot(lm4)

## One-way ANOVA
lm5 <- lm(mirex~year,data=Mirex)
# default (uses boxplots)
residPlot(lm5)
# use points rather than boxplot
residPlot(lm5,bp=FALSE)

## Two-Way ANOVA
lm6 <- lm(mirex~species*year,data=Mirex)
# default (uses boxplots)
residPlot(lm6)
# No boxplots
residPlot(lm6,bp=FALSE)

## Example showing outlier detection
x <- c(runif(100))
y <- c(7,runif(99))
lma <- lm(y~x)
residPlot(lma)
# with studentized residuals
residPlot(lm1,resid.type="studentized")

## Nonlinear regression
# from first example in nls()
DNase1 <- subset(DNase,Run==1)
fm1DNase1 <- nls(density~SSlogis(log(conc),Asym,xmid,scal),DNase1)
residPlot(fm1DNase1)
residPlot(fm1DNase1,resid.type="standardized")
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\seealso{
See \code{\link[car]{residualPlots}} in \pkg{car} and \code{\link[nlstools]{nlsResiduals}} in \pkg{nlstools}) for similar functionality and \code{\link{fitPlot}} and \code{\link[car]{outlierTest}} in \pkg{car} for related methods.
}
\keyword{hplot}
\keyword{models}

