% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spGetSAdoms.R
\name{spGetSAdoms}
\alias{spGetSAdoms}
\title{Spatial wrapper - Generate a set of model domain units for Small Area Estimation
(SAE) strategies.}
\usage{
spGetSAdoms(
  smallbnd,
  smallbnd_dsn = NULL,
  smallbnd.unique = NULL,
  smallbnd.domain = NULL,
  smallbnd.filter = NULL,
  smallbnd.stfilter = NULL,
  helperbnd = NULL,
  helperbnd_dsn = NULL,
  helperbnd.unique = NULL,
  helperbnd.filter = NULL,
  largebnd = NULL,
  largebnd_dsn = NULL,
  largebnd.unique = NULL,
  largebnd.filter = NULL,
  maxbnd = NULL,
  maxbnd_dsn = NULL,
  maxbnd.unique = NULL,
  maxbnd.filter = NULL,
  helper_autoselect = TRUE,
  nbrdom.min = NULL,
  maxbnd.threshold = 10,
  largebnd.threshold = 5,
  multiSAdoms = FALSE,
  bayes = FALSE,
  showsteps = TRUE,
  savedata = FALSE,
  savesteps = FALSE,
  saveobj = FALSE,
  objnm = "SAdomdat",
  maxbnd.addtext = TRUE,
  largebnd.addtext = FALSE,
  savedata_opts = NULL,
  addstate = FALSE,
  dissolve = FALSE,
  byeach = FALSE
)
}
\arguments{
\item{smallbnd}{sf R object or String. Small area of interest boundary.  Can
be a spatial polygon object, full pathname to a shapefile, or name of a
layer within a database.}

\item{smallbnd_dsn}{String. Data source name (dsn; e.g., sqlite or shapefile
pathname) of smallbnd. The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html). Optional if smallbnd is an R
object.}

\item{smallbnd.unique}{String. The attribute in smallbnd that defines unique
domain identifier in smallbnd that defines the unique small area(s). If
NULL, an attribute is appended to smallbnd attribute table and used as
smallbnd.unique, defining one polygon (SMALLAREA="SMALLAREA").}

\item{smallbnd.domain}{String. A different attribute to use as for grouped
modeling domains (optional). If NULL, smallbnd.domain=smallbnd.unique.}

\item{smallbnd.filter}{String. A filter for smallbnd. Must be R syntax.}

\item{smallbnd.stfilter}{String. A spatial filter for smallbnd to include
only smallbnd polygons that intersect (or overlap >= 30%) the filter
boundary. The filter is based on the stunitco internal R object, with
attributes: STATECD, STATENM, UNITCD, UNITNM, COUNTYCD, COUNTYNM. The filter
should include one of these attributes and must be R syntax.}

\item{helperbnd}{sf R object or String. Name of polygon spatial layer
delineating helper polygons for small area models. Can be a spatial polygon
object, full pathname to a shapefile, or name of a layer within a database.}

\item{helperbnd_dsn}{String. Data source name (dsn; e.g., sqlite or
shapefile pathname) of helperbnd. The dsn varies by driver. See gdal OGR
vector formats (https://www.gdal.org/ogr_formats.html). Optional if
helperbnd is an R object.}

\item{helperbnd.unique}{String. The attribute in helper polygon layer that
defines unique helper polygons.}

\item{helperbnd.filter}{String. A filter for helperbnd. Must be R syntax.}

\item{largebnd}{sf R object or String. Name of large area polygon spatial
layer, defining the model data extent for building small are models.  Can be
a spatial polygon object, full pathname to a shapefile, or name of a layer
within a database.}

\item{largebnd_dsn}{String. Data source name (dsn; e.g., sqlite or shapefile
pathname) of largebnd. The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html). Optional if largebnd is an R
object.}

\item{largebnd.unique}{String. The attribute in largebnd polygon layer that
defines unique large area polygon(s).}

\item{largebnd.filter}{String. A filter for largebnd. Must be R syntax.}

\item{maxbnd}{sf R object or String. Name of polygon spatial layer, defining
the maximum model data restraint for adding more helper polygons for
building small are models. Can be a spatial polygon object, full pathname to
a shapefile, or name of a layer within a database.}

\item{maxbnd_dsn}{String. Data source name (dsn; e.g., sqlite or shapefile
pathname) of maxbnd. The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html). Optional if maxbnd is an R object.}

\item{maxbnd.unique}{String. The attribute in maxbnd polygon layer that
defines unique max restraint area(s).}

\item{maxbnd.filter}{String. A filter for maxbnd. Must be R syntax.}

\item{helper_autoselect}{Logical. If TRUE, the helper boundaries are
automatically selected based on intersection with maxbnd and/or largebnd and
number of helperbnds defined by nbrdom.min.}

\item{nbrdom.min}{Integer. Set number for minimum domains for modeling. If
NULL, all domains within largebnd are selected.}

\item{maxbnd.threshold}{Integer. Percent for including additional maxbnds
for selecting helperbnds. If multiSAdoms=FALSE, the maxbnd with greatest
percentage over the maxbnd.threshold is selected.}

\item{largebnd.threshold}{Integer. Percent for including additional
largebnds for selecting helperbnds.}

\item{multiSAdoms}{Logical. If TRUE, and the percent intersect of smallbnd
with maxbnd is greater than maxbnd.threshold, more than 1 SAdoms will be
output in list.}

\item{bayes}{Logical. If TRUE, does not union smallbnd with largebnd.
If multiSAdoms = TRUE, returns intersecting maxbnd where larger than 
maxbnd threshold.}

\item{showsteps}{Logical. If TRUE, intermediate steps of selection process
are displayed.}

\item{savedata}{Logical. If TRUE, save SAdoms spatial layer to outfolder.}

\item{savesteps}{Logical. If TRUE, save steps spatial intermediate layers
and JPG images. All spatial layers are output as *.shp format in a separate
folder (SAdoms_steps).}

\item{saveobj}{Logical. If TRUE, save SAdomdat object to outfolder.}

\item{objnm}{String. Name of *.rds object.}

\item{maxbnd.addtext}{Logical. If TRUE, adds text to intermediate step plots
for maxbnd displays.}

\item{largebnd.addtext}{Logical. If TRUE, adds text to intermediate step
plots for largebnd displays.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}

\item{addstate}{Logical. If TRUE, appends state attribute to SAdoms.}

\item{dissolve}{Logical. If TRUE, aggregates polygons to smallbnd.domain or
smallbnd.unique.}

\item{byeach}{Logical. If TRUE, creates an SAdom for each smallbnd polygon.}
}
\value{
\item{SAdomslst}{ List object. Set(s) of model domain units. If
multiSAdoms=TRUE, the list may have more than one set of model domain units.
} \item{smallbndlst}{ List object. smallbnd(s). If multiSAdoms=TRUE, the
list may have more than one set of smallbnd. }

If exportsp=TRUE, the SAdoms spatial object(s) is exported to outfolder,
with format specified by out_fmt.
}
\description{
Spatial process to generate a set of model domains (i.e., helper polygons)
for Small Area Estimation (SAE) strategies. If helper_autoselect=TRUE, an
automated process is used to select helper polygons within a large area
overlapping the small area. The helper polygons are unioned with the small
area polygons, resulting in a set of model domains that can be used for SAE.
}
\details{
\bold{optional boundaries}

The helperbnd, largebnd, and maxbnd are optional. If helperbnd=NULL, the
smallbnd polygons are used for model domain units. If largebnd=NULL, the
maxbnd is used to define the large area. If maxbnd=NULL, the largebnd is
used to restrain the model extent. If both, largebnd=NULL and maxbnd=NULL,
the extent of the smallbnd or helperbnd is used for defining and restraining
the model extent.

\bold{nbrdom.min}

The number of helper polygons selected are defined by nbrdom.min parameter.
If nbrdom.min=NULL, all helper polygons within the large area extent are
selected.

\bold{multiSAdoms}

Use multiSAdoms parameter when small area of interest has multiple polygon
features and the small area polygons overlap (within maxbnd.threshold) more
than one maxbnd polygon. If multiSAdoms=TRUE, more than one set of model
domain units are generated; one for each maxbnd where overlap is within
maxbnd.threshold. If multiSAdoms=FALSE, only one set of model domain units
are generated, using the maxbnd with the greatest overlap.

\bold{AOI attribute}

A variable named 'AOI' is appended to the SAdoms attribute table to
distinguish between the small area of interest polygons and the helper
domain units.
}
\note{
If exportsp=TRUE and out_fmt="shp":\cr The st_write (sf) function is
called. The ArcGIS driver truncates variable names to 10 characters or less.
Variable names are changed before export using an internal function
(trunc10shp). If Spatial object has more than 1 record, it will be returned
but not exported.

The spTransform (sf) method is used for on-the-fly map projection
conversion and datum transformation using PROJ.4 arguments. Datum
transformation only occurs if the +datum tag is present in the both the from
and to PROJ.4 strings. The +towgs84 tag is used when no datum transformation
is needed. PROJ.4 transformations assume NAD83 and WGS84 are identical
unless other transformation parameters are specified.  Be aware, providing
inaccurate or incomplete CRS information may lead to erroneous data shifts
when reprojecting. See spTransform help documentation for more details.
}
\author{
Tracey S. Frescino
}
\keyword{data}
