% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modSApop.R
\name{modSApop}
\alias{modSApop}
\title{Small area module - Compile population data for SA module.}
\usage{
modSApop(
  popType = "VOL",
  popTabs = popTables(),
  popTabIDs = popTableIDs(),
  popFilter = popFilters(),
  pltassgn = NULL,
  pltassgnid = "PLT_CN",
  dsn = NULL,
  pjoinid = "CN",
  areawt = "CONDPROP_UNADJ",
  adjplot = TRUE,
  dunitvar = NULL,
  dunitarea = NULL,
  areavar = "ACRES",
  dunitzonal = NULL,
  prednames = NULL,
  predfac = NULL,
  returndata = TRUE,
  savedata = FALSE,
  saveobj = FALSE,
  objnm = "SApopdat",
  unit_opts = NULL,
  savedata_opts = NULL,
  SAdoms = NULL,
  smallbnd = NULL,
  smallbnd.domain = NULL,
  SAdata = NULL,
  pltdat = NULL,
  auxdat = NULL,
  gui = FALSE,
  ...
)
}
\arguments{
\item{popType}{String. Type of evaluation(s) to include in population data.
Note: currently only c('CURR', 'VOL', 'LULC') are available. See details
below for descriptions of each.}

\item{popTabs}{List of population tables the user would like returned.
See help(popTables) for a list of options.}

\item{popTabIDs}{List of unique IDs corresponding to the population tables
that the user has requested. See help(popTableIDs) for a list of
options.}

\item{popFilter}{List of population filters. See help(popFilters) for a 
list of options.}

\item{pltassgn}{DF/DT, comma-separated values (CSV) file(*.csv), or layer in
dsn, Can also be a shapefile(*.shp) with one record per plot, a spatial
layer in dsn, or a sf R object. Plot-level assignment of estimation unit
and/or strata. Optional.}

\item{pltassgnid}{String. Unique identifier of plot in pltassgn.}

\item{dsn}{String. Name of database where tree, cond, and pltassgn tables
reside.  The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html).}

\item{pjoinid}{String. Join variable in plot to match pltassgnid. Does not
need to be uniqueid. If using most current XY coordinates for plot
assignments, use identifier for plot (e.g., PLOT_ID).}

\item{areawt}{String. Name of variable for summarizing area weights (e.g.,
CONDPROP_UNADJ).}

\item{adjplot}{Logical. If TRUE, adjusts for nonresponse at plot-level.}

\item{dunitvar}{String. Name of the domain unit variable in cond, plt, or
pltassgn with domain unit assignment for each plot.}

\item{dunitarea}{Numeric or DF. Total area by domain unit.}

\item{areavar}{String. Name of area variable in unitarea. Default="ACRES".}

\item{dunitzonal}{DF/DT. Data frame with zonal auxiliary information by
domain unit. For continuous data, means by domain unit; for categorical
data, proportion of class by domain unit.}

\item{prednames}{String vector. Name(s) of predictor variables to use in
model.}

\item{predfac}{String vector. Name(s) of factor predictor variables to use
in model. Names will change in output depending on number of categories.}

\item{returndata}{Logical. If TRUE, returns data objects.}

\item{savedata}{Logical. If TRUE, saves table(s) to outfolder.}

\item{saveobj}{Logical. If TRUE, saves returned list object to outfolder.}

\item{objnm}{String. Name of *.rds object.}

\item{unit_opts}{List. See help(unit_options()) for a list of options.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options.}

\item{SAdoms}{sf object. SA domains with attributes for joining.}

\item{smallbnd}{sf object. small bound.}

\item{smallbnd.domain}{String. Name of attribute defining domain attribute.}

\item{SAdata}{R List object. Output data list components from
FIESTA::SAdata().}

\item{pltdat}{R List object. Output data list components from
FIESTA::spGetPlots().}

\item{auxdat}{R List object. Output data list components from
FIESTA::spGetAuxiliary().}

\item{gui}{Logical. If gui, user is prompted for parameters.}

\item{...}{For extendibility.}
}
\value{
A list with population data for Small-Area estimates.

\item{SAdomsdf}{ Data frame. Attribute table from SAdoms spatial layer.
Includes DOMAIN and AOI attributes. DOMAIN represents modeling domains.  AOI
identifies the small area of interest. } 
\item{condx}{ Data frame. Condition-level data with condition proportions, 
domain and predictor assignments, and adjusted condition proportions, 
if adjplot = TRUE. } 
\item{pltcondx}{ Data frame. Plot/Condition data used for estimation. }
\item{cuniqueid}{ String. Unique identifier of plot in condx and pltcondx. }
\item{condid}{ String. Unique identifier of condition in condx and pltcondx. } 
\item{treex}{ Data frame. If esttype='TREE', tree-level data, including
adjustment factors, if adjplot = TRUE. } 
\item{tuniqueid}{ String. If esttype='TREE', unique identifier of plot in 
treex. } 
\item{ACI.filter}{ String. If ACI=FALSE, ACI.filter="COND_STATUS_CD == 1" . } 
\item{dunitarea}{ Data frame. Area by model domain unit. } 
\item{areavar}{ String. Name of area variable in dunitarea. } 
\item{dunitvar}{ String. Name of variable defining model domain units in 
dunitarea. } 
\item{dunitlut}{ Data frame. Table of model domain units with zonal statistics 
of predictor values, number of plots by domain unit. } 
\item{prednames}{ String vector. Name of variables in dunitlut and condx 
defining potential predictors for small area estimation. } 
\item{plotsampcnt}{ Data frame. Number of plots by PLOT_STATUS_CD. } 
\item{condsampcnt}{ Data frame. Number of conditions by COND_STATUS_CD. } 
\item{states}{ String. State names in dataset. }
\item{invyrs}{ String. Range of inventory years in dataset. }
\item{adjtree}{ Logical. If TRUE, treex includes adjustment factors. }
}
\description{
Compile population data for input to the modSA* modules.
}
\details{
If variables are NULL, then it will prompt user to input variables.

Necessary variables:\cr \tabular{llll}{ \tab \bold{Data} \tab
\bold{Variable} \tab \bold{Description}\cr 
\tab tree \tab tuniqueid \tab Unique identifier for each plot, to link to 
pltassgn (e.g. PLT_CN).\cr 
\tab \tab CONDID \tab Unique identifier of each condition on plot, to link to
cond.  Set CONDID=1, if only 1 condition per plot.\cr 
\tab \tab TPA_UNADJ \tab Number of trees per acre each sample tree 
represents (e.g. DESIGNCD=1: TPA_UNADJ=6.018046 for trees on subplot; 
74.965282 for trees on microplot).\cr 
\tab cond \tab cuniqueid \tab Unique identifier for each plot, to link to 
pltassgn (e.g. PLT_CN).\cr 
\tab \tab CONDID \tab Unique identifier of each condition on plot. Set 
CONDID=1, if only 1 condition per plot.\cr 
\tab \tab CONDPROP_UNADJ \tab Unadjusted proportion of condition on
each plot.  Set CONDPROP_UNADJ=1, if only 1 condition per plot.\cr 
\tab \tab COND_STATUS_CD \tab Status of each forested condition on plot (i.e.
accessible forest, nonforest, water, etc.)\cr 
\tab \tab NF_COND_STATUS_CD \tab If ACI=TRUE. Status of each nonforest 
condition on plot (i.e. accessible nonforest, nonsampled nonforest)\cr 
\tab \tab SITECLCD \tab If landarea=TIMBERLAND. Measure of site productivity.\cr 
\tab \tab RESERVCD \tab If landarea=TIMBERLAND. Reserved status.\cr 
\tab \tab SUBPROP_UNADJ \tab Unadjusted proportion of subplot conditions 
on each plot. Set SUBPROP_UNADJ=1, if only 1 condition per subplot.\cr 
\tab \tab MICRPROP_UNADJ \tab If microplot tree attributes. Unadjusted 
proportion of microplot conditions on each plot. Set MICRPROP_UNADJ=1, 
if only 1 condition per microplot.\cr 
\tab \tab MACRPROP_UNADJ \tab If macroplot tree attributes. Unadjusted 
proportion of macroplot conditions on each plot. Set MACRPROP_UNADJ=1, 
if only 1 condition per macroplot.\cr 
\tab pltassgn \tab puniqueid \tab Unique identifier for each plot, to 
link to cond (e.g. CN).\cr 
\tab \tab STATECD \tab Identifies state each plot is located in.\cr 
\tab \tab INVYR \tab Identifies inventory year of each plot.\cr 
\tab \tab PLOT_STATUS_CD \tab Status of each plot (i.e. sampled, nonsampled).  
If not included, all plots are assumed as sampled.\cr }

For available reference tables: sort(unique(FIESTAutils::ref_codes$VARIABLE)) \cr
}
\note{
ADJUSTMENT FACTOR:\cr The adjustment factor is necessary to account for
nonsampled conditions.  For model-based estimation, we calculate adjustment
factors by plot.

It is calculated by dividing 1 / summed condition proportions by plot. An
adjustment factor is determined for each tree based on the size of the plot
it was measured on. This is identified using TPA_UNADJ as follows:

\tabular{llr}{ \tab \bold{PLOT SIZE} \tab \bold{TPA_UNADJ} \cr 
\tab SUBPLOT \tab 6.018046 \cr 
\tab MICROPLOT \tab 74.965282 \cr 
\tab MACROPLOT \tab 0.999188 \cr }

If ACI=FALSE, only nonsampled forest conditions are accounted for in the
adjustment factor. \cr 
If ACI=TRUE, the nonsampled nonforest conditions are removed as well and 
accounted for in adjustment factor.  This is if you are interested in 
estimates for all lands or nonforest lands in the All-Condition-Inventory.
}
\examples{
\donttest{
# NOTE: FIA data objects used in these examples are stored in `FIESTA`, but
# can be generated for populations of interest by the user with functions in
# `FIESTA` such as `spGetPlots()`, `spGetAuxiliary()`, etc. For more
# information, see `FIESTA`'s extensive vignettes.
 
# Population data for counties in Wyoming
modSApop(popTabs = list(tree = FIESTA::WYtree,
                        cond = FIESTA::WYcond),
         pltassgn = FIESTA::WYpltassgn,
         pltassgnid = "CN",
         dunitarea = FIESTA::WYunitarea,
         dunitvar = "ESTN_UNIT",
         dunitzonal = FIESTA::WYunitzonal,
         prednames = c("dem", "tcc", "tpi", "tnt"),
         predfac = "tnt")
         
# Adding seedling data as well
modSApop(popTabs = list(tree = FIESTA::WYtree,
                        cond = FIESTA::WYcond,
                        seed = FIESTA::WYseed),
         pltassgn = FIESTA::WYpltassgn,
         pltassgnid = "CN",
         dunitarea = FIESTA::WYunitarea,
         dunitvar = "ESTN_UNIT",
         dunitzonal = FIESTA::WYunitzonal,
         prednames = c("dem", "tcc", "tpi", "tnt"),
         predfac = "tnt")
}
}
\author{
Tracey S. Frescino, Paul L. Patterson
}
\keyword{data}
