% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{formula.femlm}
\alias{formula.femlm}
\title{Extract the formula of a femlm fit}
\usage{
\method{formula}{femlm}(x, type = c("full", "linear", "NL"), ...)
}
\arguments{
\item{x}{An object of class \code{femlm}. Typically the result of a \code{\link[FENmlm]{femlm}} estimation.}

\item{type}{A character scalar. Default is \code{type = "full"} which gives back a formula containing the linear part of the model along with the clusters (if any) and the non-linear in parameters part (if any). If \code{type = "linear"} then only the linear formula is returned. If \code{type = "NL"} then only the non linear in parameters part is returned.}

\item{...}{Not currently used.}
}
\value{
It returns a formula.
}
\description{
This function extracts the formula from a \code{\link[FENmlm]{femlm}} estimation. If the estimation was done with fixed-effects, they are added in the formula after a pipe (\dQuote{|}). If the estimation was done with a non linear in parameters part, then this will be added in the formula in between \code{I()}.
}
\examples{

# simple estimation on iris data, clustering by "Species"
res = femlm(Sepal.Length ~ Sepal.Width + Petal.Length +
            Petal.Width | Species, iris)

# formula with the cluster variable
formula(res)
# linear part without the cluster variable
formula(res, "linear")


}
\seealso{
\code{\link[FENmlm]{femlm}}, \code{\link[FENmlm]{model.matrix.femlm}}, \code{\link[FENmlm]{update.femlm}}, \code{\link[FENmlm]{summary.femlm}}, \code{\link[FENmlm]{vcov.femlm}}.
}
\author{
Laurent Berge
}
