% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/methods.R
\name{extract.blg}
\alias{extract.blg}
\title{Extract information of a base-learner}
\usage{
\method{extract}{blg}(object, what = c("design", "penalty", "index"),
  asmatrix = FALSE, expand = FALSE, ...)
}
\arguments{
\item{object}{a base-learner}

\item{what}{a character specifying the quantities to extract.
This can be a subset of "design" (default; design matrix),
"penalty" (penalty matrix) and "index" (index of ties used to expand
the design matrix)}

\item{asmatrix}{a logical indicating whether the the returned matrix should be
coerced to a matrix (default) or if the returned object stays as it is
(i.e., potentially a sparse matrix). This option is only applicable if extract
returns matrices, i.e., what = "design" or what = "penalty".}

\item{expand}{a logical indicating whether the design matrix should be expanded
(default: FALSE). This is useful if ties where taken into account either manually
(via argument index in a base-learner) or automatically for data sets with many
observations. expand = TRUE is equivalent to extract(B)[extract(B, what = "index"),]
for a base-learner B.}

\item{...}{currently not used}
}
\description{
Takes a base-learner and extracts information.
}
\seealso{
\code{\link[mboost]{extract}} for the extract functions of the package mboost
}

