% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readFileTiff.R
\name{readFileTiff}
\alias{readFileTiff}
\title{Read File Tiff}
\usage{
readFileTiff(filename, invert = TRUE)
}
\arguments{
\item{filename}{Either name of the file to read from or a raw vector representing the TIFF file content.}

\item{invert}{If set to TRUE then the order of the data will be reversed. Default TRUE.}
}
\value{
A matrix containing the image data.
}
\description{
Reads a TIFF file and converts it into a 2D-array. If the file contains multiple pages, a 3D-array will be then returned.
}
\details{
Read a TIFF file image using readTIFF and converts it to a matrix with n-dimensions.
}
\note{
This function must been used in order to use the rest of the functions in this package. The tiff file must be grayscale.
}
\examples{
\donttest{
raw <- readFileTiff(FileName)
}
}
\seealso{
\code{\link{readTIFF}} \code{\link{writeFileTiff}}
}
\author{
Adan O. Guerrero Cardenas.
}
