% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlp_net.R
\name{mlp_net-single-weight-access}
\alias{mlp_get_w}
\alias{mlp_get_w_st}
\alias{mlp_net-single-weight-access}
\alias{mlp_set_w}
\alias{mlp_set_w_st}
\title{Setting and retrieving single weight's status (on/off) and value}
\usage{
mlp_set_w_st(net, on, idx = NULL, layer = NULL, nidx = NULL,
  nplidx = NULL)

mlp_set_w(net, val, idx = NULL, layer = NULL, nidx = NULL,
  nplidx = NULL)

mlp_get_w_st(net, idx = NULL, layer = NULL, nidx = NULL, nplidx = NULL)

mlp_get_w(net, idx = NULL, layer = NULL, nidx = NULL, nplidx = NULL)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{on}{logical value, should the weight be set on or off?}

\item{idx}{integer value, weight absolute index}

\item{layer}{integer value, layer index}

\item{nidx}{integer value, neuron index}

\item{nplidx}{integer value, index of the neuron in the previous layer determining connection
              from neuron \code{nidx} in \code{layer}, 0 denotes bias
              of neuron \code{nidx} in \code{layer}}

\item{val}{numeric value, connection (or bias) value to be set}
}
\value{
\code{mlp_set_w_st} returns network (an object of \code{mlp_net} class)
                   with state (on/off) of selected  weight set.

        \code{mlp_set_w} returns network (an object of \code{mlp_net} class)
                   with value of selected weight set.

        \code{mlp_get_w_st} returns logical value, TRUE if connection/bias is active,
                   FALSE otherwise.

        \code{mlp_get_w} returns numeric value, selected weight value.
}
\description{
The following functions can be used to access a single weight, i.e. set or
retrieve its status (on/off) and value.
}

