% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_risk.R
\name{quantile_risk}
\alias{quantile_risk}
\title{Extract Conditional Quantile from \code{fars_density} Object}
\usage{
quantile_risk(density, qtau = 0.05)
}
\arguments{
\item{density}{An object of class \code{fars_density}, which is returned by \code{compute_density()}}

\item{qtau}{A numeric value between 0 and 1 indicating the quantile to extract (e.g., 0.05 for the 5th percentile). Default is 0.05.}
}
\value{
A numeric vector of conditional quantiles (one observation for each time period).
}
\description{
Computes the conditional quantile (e.g., 5th percentile) from a simulated skew-t distribution,
The result corresponds to the risk measure (e.g., Growth-at-Risk, Growth-in-Stress etc.).
}
\examples{
\donttest{
quantiles <- matrix(rnorm(500), ncol = 5)
fars_density <- compute_density(quantiles, seed = 42)
GaR <- quantile_risk(fars_density, qtau = 0.05)
}

}
