% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination_geo.R
\name{recombination_geo}
\alias{recombination_geo}
\title{Geometric recombination for DE}
\usage{
recombination_geo(X, M, recpars = list(alpha = 0.5))
}
\arguments{
\item{X}{population matrix (original)}

\item{M}{population matrix (mutated)}

\item{recpars}{recombination parameters (see \code{Recombination parameters} 
for details)}
}
\value{
Matrix \code{U} containing the recombined population
}
\description{
Implements the "/geo" (geometric) recombination for the ExpDE framework
}
\section{Recombination Parameters}{

The \code{recpars} parameter contains all parameters required to define the 
recombination. \code{recombination_geo()} understands the following 
fields in \code{recpars}:
\itemize{
   \item \code{alpha} : exponent for geometrical recombination.\cr
   Accepts numeric value \code{0 <= alpha <= 1} or \code{NULL} (in which 
   case a random value is chosen for each recombination).\cr
   Defaults to \code{alpha = 0.5}.
}
}

\section{References}{

F. Herrera, M. Lozano, A. M. Sanchez, "A taxonomy for the crossover
operator for real-coded genetic algorithms: an experimental study", 
International Journal of Intelligent Systems 18(3) 309-338, 2003.
}

