% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estPlots.R
\name{aarPlot}
\alias{aarPlot}
\title{Averaged Abnormal Return Plot}
\usage{
aarPlot(ResultParserObj, cumSum = F, group = NULL, window = NULL,
  ciStatistics = NULL, p = 0.95, ciType = "band", xlab = "",
  ylab = "Averaged Abnormal Returns", facet = T, ncol = 4)
}
\arguments{
\item{ResultParserObj}{An object of class \code{ResultParser}}

\item{cumSum}{plot CAAR}

\item{group}{set this parameter if just one group should be plotted}

\item{window}{numeric vector of length 2}

\item{ciStatistics}{Statistic used for confidence intervals}

\item{p}{p-value}

\item{ciType}{type of CI band}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{facet}{should each firm get its own plot (default = T)}

\item{ncol}{number of facet columns}
}
\value{
a ggplot2 object
}
\description{
Averaged abnormal return plots with confidence intervals

For more details see the help vignette:
\code{vignette("parameters_eventstudy", package = "EventStudy")}
}
\examples{
\dontrun{
# plot averaged abnormal returns in one plot
aarPlot(resultParser)

# plot averaged abnormal returns with .95-CI
arPlot(resultParser, ciStatistics = "Patell Z",p = .95)
}

}
