% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar.evaluate.core.R
\name{bar.evaluate.core}
\alias{bar.evaluate.core}
\title{Bar Plots}
\usage{
bar.evaluate.core(data, names, qualitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
A list with the \code{ggplot} objects of relative frequency bar plots
  of CS and EC for each trait specified as \code{qualitative}.
}
\description{
Plot Bar plots to graphically compare the frequency distributions of
qualitative traits between entire collection (EC) and core set (CS).
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

bar.evaluate.core(data = ec, names = "genotypes",
                  qualitative = qual, selected = core)


}
\seealso{
\code{\link[graphics]{barplot}}, \code{\link[ggplot2]{geom_bar}}
}
