% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinkFunc.R
\name{NegInv_link}
\alias{NegInv_link}
\title{Negative inverse link function (for estimation with \code{maxlogL})}
\usage{
NegInv_link()
}
\value{
A list with negative inverse link function, its inverse and its name.
}
\description{
\code{NegInv_link} object provides a way to implement negative inverse link function that
\code{\link{maxlogL}} needs to perform estimation. See documentation for
\code{\link{maxlogL}} for further information on parameter estimation and implementation
of link objects.
}
\details{
\code{NegInv_link} is part of a family of generic functions with no input arguments that
defines and returns a list with details of the link function:
\enumerate{
   \item \code{name}: a character string with the name of the link function.
   \item \code{g}: implementation of the link function as a generic function in \code{R}.
   \item \code{g_inv}: implementation of the inverse link function as a generic function
         in \code{R}.
}

There is a way to add new mapping functions. The user must specify the details aforesaid.
}
\examples{
# Estimation of rate parameter in exponential distribution
T <- rexp(n = 1000, rate = 3)
lambda <- maxlogL(x = T, dist = "dexp", start = 5,
                  link = list(over = "rate", fun = "NegInv_link"))
summary(lambda)

# Link function name
fun <- NegInv_link()$name
print(fun)

# Link function
g <- NegInv_link()$g
curve(g(x), from = 0.1, to = 1)

# Inverse link function
ginv <- NegInv_link()$g_inv
curve(ginv(x), from = 0.1, to = 1)

}
\seealso{
\code{\link{maxlogL}}

Other link functions: \code{\link{log_link}},
  \code{\link{logit_link}}
}
\concept{link functions}
