% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{body_replace_gg_at_bkm}
\alias{body_replace_gg_at_bkm}
\title{Replace a plot at a bookmark location}
\usage{
body_replace_gg_at_bkm(doc, gg, bookmark, width = 6, height = 3)
}
\arguments{
\item{doc}{a docx device}

\item{gg}{a ggplot object or any object that can be printed in grDevices::png()}

\item{bookmark}{bookmark id}

\item{width}{the width of the device in inches}

\item{height}{the height of the device.}
}
\value{
doc
}
\description{
Replace a plot at a bookmark location saving it as a PNG file in a temporary
folder. \cr
A bookmark will be considered as valid if enclosing words within a paragraph;
i.e., a bookmark along two or more paragraphs is invalid,
a bookmark set on a whole paragraph is also invalid,
but bookmarking few words inside a paragraph is valid.
}
\examples{
doc <- officer::read_docx(path = file.path(system.file(package = "EpiReport"),
                                           "template/AER_template.docx" ))
p <- EpiReport::getTrend()
doc <- EpiReport::body_replace_gg_at_bkm(doc = doc,
                                         gg = p,
                                         bookmark = "TS_TREND",
                                         width = 6,
                                         height = 3)

}
