% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_rt_data}
\alias{create_rt_data}
\title{Create Time-varying Reproduction Number Data}
\usage{
create_rt_data(rt = rt_opts(), breakpoints = NULL, delay = 0, horizon = 0)
}
\arguments{
\item{rt}{A list of options as generated by \code{\link[=rt_opts]{rt_opts()}} defining Rt
estimation. Defaults to \code{\link[=rt_opts]{rt_opts()}}. To generate new infections using
the non-mechanistic model instead of the renewal equation model, use
\code{rt = NULL}. The non-mechanistic model internally uses the setting
\code{rt = rt_opts(use_rt = FALSE, future = "project", gp_on = "R0")}.}

\item{breakpoints}{An integer vector (binary) indicating the location of
breakpoints.}

\item{delay}{Numeric mean delay}

\item{horizon}{Numeric, forecast horizon.}
}
\value{
A list of settings defining the time-varying reproduction number
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Takes the output from \code{\link[=rt_opts]{rt_opts()}} and converts it into a list understood by
stan.
}
\examples{
\dontrun{
# default Rt data
create_rt_data()

# settings when no Rt is desired
create_rt_data(rt = NULL)

# using breakpoints
create_rt_data(rt_opts(use_breakpoints = TRUE), breakpoints = rep(1, 10))

# using random walk
create_rt_data(rt_opts(rw = 7), breakpoints = rep(1, 10))
}
}
\seealso{
rt_settings
}
\keyword{internal}
