% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{generation_time_opts}
\alias{generation_time_opts}
\title{Generation Time Distribution Options}
\usage{
generation_time_opts(
  dist = dist_spec(mean = 1),
  ...,
  disease,
  source,
  max = 15L,
  fixed = FALSE,
  prior_weight
)
}
\arguments{
\item{dist}{A delay distribution or series of delay distributions generated
using \code{\link[=dist_spec]{dist_spec()}} or \code{\link[=get_generation_time]{get_generation_time()}}. If no distribution is given
a fixed generation time of 1 will be assumed.}

\item{...}{deprecated; use \code{dist} instead}

\item{disease}{deprecated; use \code{dist} instead}

\item{source}{deprecated; use \code{dist} instead}

\item{max}{deprecated; use \code{dist} instead}

\item{fixed}{deprecated; use \code{dist} instead}

\item{prior_weight}{deprecated; prior weights are now specified as a
model option. Use the \code{weigh_delay_priors} argument of \code{estimate_infections}
instead.}
}
\value{
A list summarising the input delay distributions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Returns generation time parameters in a format for lower level model use. The
generation time can either be given as a \code{disease} and \code{source} to
be passed to \link{get_generation_time}, or as parameters of a distribution to be
passed to \link{dist_spec}.
}
\examples{
# default settings with a fixed generation time of 1
generation_time_opts()

# A fixed gamma distributed generation time
generation_time_opts(dist_spec(mean = 3, sd = 2, max = 15))

# An uncertain gamma distributed generation time
generation_time_opts(
 dist_spec(mean = 3, sd = 2, mean_sd = 1, sd_sd = 0.5, max = 15)
)

# A generation time sourced from the literature
dist <- get_generation_time(disease = "SARS-CoV-2", source = "ganyani")
generation_time_opts(dist)
}
\seealso{
convert_to_logmean convert_to_logsd bootstrapped_dist_fit dist_spec
}
\author{
Sebastian Funk

Sam Abbott
}
