% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnrichDO_visualization.R
\name{drawGraphViz}
\alias{drawGraphViz}
\title{drawGraphViz}
\usage{
drawGraphViz(
  EnrichResult = NULL,
  enrich = NULL,
  n = 10,
  labelfontsize = 14,
  numview = TRUE,
  pview = TRUE
)
}
\arguments{
\item{EnrichResult}{the EnrichResult object}

\item{enrich}{a data frame of the enrichment result}

\item{n}{the number of most significant nodes}

\item{labelfontsize}{the font size of nodes}

\item{numview}{Displays the number of intersections between the interest set and each doterm.}

\item{pview}{Displays the P value for each dotrem.}
}
\value{
tree diagram
}
\description{
the enrichment results are shown in a tree diagram
}
\examples{
demo.data <- c(1636,351,102,2932,3077,348,4137,54209)
sample5 <- doEnrich(interestGenes=demo.data,maxGsize = 100, minGsize=10)
drawGraphViz(EnrichResult =sample5)

#The p-value and the number of intersections are not visible
drawGraphViz(EnrichResult=sample5, numview = FALSE, pview = FALSE)
}
\author{
Haixiu Yang
}
