% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotCalibrationEffect}
\alias{plotCalibrationEffect}
\title{Plot the effect of the calibration}
\usage{
plotCalibrationEffect(logRrNegatives, seLogRrNegatives, logRrPositives,
  seLogRrPositives, null = NULL, alpha = 0.05, xLabel = "Relative risk",
  title, showCis = FALSE, fileName = NULL)
}
\arguments{
\item{logRrNegatives}{A numeric vector of effect estimates of the negative controls on the log
scale.}

\item{seLogRrNegatives}{The standard error of the log of the effect estimates of the negative
controls.}

\item{logRrPositives}{A numeric vector of effect estimates of the positive controls on the log
scale.}

\item{seLogRrPositives}{The standard error of the log of the effect estimates of the positive
controls.}

\item{null}{An object representing the fitted null distribution as created by the
\code{fitNull} or \code{fitMcmcNull} functions. If not provided, a null 
will be fitted before plotting.}

\item{alpha}{The alpha for the hypothesis test.}

\item{xLabel}{The label on the x-axis: the name of the effect estimate.}

\item{title}{Optional: the main title for the plot}

\item{showCis}{Show 95 percent credible intervals for the calibrated p = alpha boundary.}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'.
See the function \code{ggsave} in the ggplot2 package for supported file
formats.}
}
\value{
A Ggplot object. Use the \code{ggsave} function to save to file.
}
\description{
\code{plotCalibrationEffect} creates a plot showing the effect of the calibration.
}
\details{
Creates a plot with the effect estimate on the x-axis and the standard error on the y-axis.
Negative controls are shown as blue dots, positive controls as yellow diamonds. The area below the
dashed line indicated estimates with p < 0.05. The orange area indicates estimates with calibrated
p < 0.05.
}
\examples{
data(sccs)
negatives <- sccs[sccs$groundTruth == 0, ]
positive <- sccs[sccs$groundTruth == 1, ]
plotCalibrationEffect(negatives$logRr, negatives$seLogRr, positive$logRr, positive$seLogRr)

}
