// Generated by rstantools.  Do not edit by hand.

#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_multi_steep_fixed_sd_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_multi_steep_fixed_sd");
    reader.add_event(164, 162, "end", "model_multi_steep_fixed_sd");
    return reader;
}
template <typename T0__, typename T1__, typename T2__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type>
ProbFunction(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& EloStart,
                 const T1__& k,
                 const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& presence,
                 const int& N,
                 const int& K,
                 const std::vector<int>& winner_index,
                 const std::vector<int>& loser_index, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 3;
        validate_non_negative_index("result", "N", N);
        std::vector<local_scalar_t__  > result(N, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(result, DUMMY_VAR__);
        stan::math::fill(result, DUMMY_VAR__);
        current_statement_begin__ = 4;
        local_scalar_t__ toAdd(DUMMY_VAR__);
        (void) toAdd;  // dummy to suppress unused var warning
        stan::math::initialize(toAdd, DUMMY_VAR__);
        stan::math::fill(toAdd, DUMMY_VAR__);
        current_statement_begin__ = 6;
        validate_non_negative_index("EloNow", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> EloNow(K);
        stan::math::initialize(EloNow, DUMMY_VAR__);
        stan::math::fill(EloNow, DUMMY_VAR__);
        current_statement_begin__ = 7;
        for (int j = 1; j <= K; ++j) {
            current_statement_begin__ = 8;
            stan::model::assign(EloNow, 
                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                        get_base1(EloStart, j, "EloStart", 1), 
                        "assigning variable EloNow");
        }
        current_statement_begin__ = 10;
        for (int i = 1; i <= N; ++i) {
            current_statement_begin__ = 12;
            stan::math::assign(EloNow, subtract(EloNow, (dot_product(row(presence, i), EloNow) / sum(row(presence, i)))));
            current_statement_begin__ = 14;
            stan::model::assign(result, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        (1 / (1 + stan::math::exp((get_base1(EloNow, get_base1(loser_index, i, "loser_index", 1), "EloNow", 1) - get_base1(EloNow, get_base1(winner_index, i, "winner_index", 1), "EloNow", 1))))), 
                        "assigning variable result");
            current_statement_begin__ = 16;
            stan::math::assign(toAdd, ((1 - get_base1(result, i, "result", 1)) * k));
            current_statement_begin__ = 18;
            stan::model::assign(EloNow, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(winner_index, i, "winner_index", 1)), stan::model::nil_index_list()), 
                        (get_base1(EloNow, get_base1(winner_index, i, "winner_index", 1), "EloNow", 1) + toAdd), 
                        "assigning variable EloNow");
            current_statement_begin__ = 19;
            stan::model::assign(EloNow, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(loser_index, i, "loser_index", 1)), stan::model::nil_index_list()), 
                        (get_base1(EloNow, get_base1(loser_index, i, "loser_index", 1), "EloNow", 1) - toAdd), 
                        "assigning variable EloNow");
        }
        current_statement_begin__ = 21;
        return stan::math::promote_scalar<fun_return_scalar_t__>(result);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct ProbFunction_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& EloStart,
                 const T1__& k,
                 const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& presence,
                 const int& N,
                 const int& K,
                 const std::vector<int>& winner_index,
                 const std::vector<int>& loser_index, std::ostream* pstream__) const {
        return ProbFunction(EloStart, k, presence, N, K, winner_index, loser_index, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
cum_winprob(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& EloStart,
                const T1__& k,
                const int& n_interactions,
                const int& n_ids,
                const std::vector<int>& winner_index,
                const std::vector<int>& loser_index, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 25;
        local_scalar_t__ single_wp(DUMMY_VAR__);
        (void) single_wp;  // dummy to suppress unused var warning
        stan::math::initialize(single_wp, DUMMY_VAR__);
        stan::math::fill(single_wp, DUMMY_VAR__);
        current_statement_begin__ = 26;
        local_scalar_t__ toAdd(DUMMY_VAR__);
        (void) toAdd;  // dummy to suppress unused var warning
        stan::math::initialize(toAdd, DUMMY_VAR__);
        stan::math::fill(toAdd, DUMMY_VAR__);
        current_statement_begin__ = 27;
        validate_non_negative_index("pairwise_winprobs", "n_ids", n_ids);
        validate_non_negative_index("pairwise_winprobs", "n_ids", n_ids);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> pairwise_winprobs(n_ids, n_ids);
        stan::math::initialize(pairwise_winprobs, DUMMY_VAR__);
        stan::math::fill(pairwise_winprobs, DUMMY_VAR__);
        current_statement_begin__ = 28;
        validate_non_negative_index("cumwinprobs", "n_ids", n_ids);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cumwinprobs(n_ids);
        stan::math::initialize(cumwinprobs, DUMMY_VAR__);
        stan::math::fill(cumwinprobs, DUMMY_VAR__);
        current_statement_begin__ = 31;
        validate_non_negative_index("EloNow", "n_ids", n_ids);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> EloNow(n_ids);
        stan::math::initialize(EloNow, DUMMY_VAR__);
        stan::math::fill(EloNow, DUMMY_VAR__);
        current_statement_begin__ = 32;
        for (int j = 1; j <= n_ids; ++j) {
            current_statement_begin__ = 33;
            stan::model::assign(EloNow, 
                        stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()), 
                        get_base1(EloStart, j, "EloStart", 1), 
                        "assigning variable EloNow");
        }
        current_statement_begin__ = 35;
        for (int i = 1; i <= n_interactions; ++i) {
            current_statement_begin__ = 36;
            stan::math::assign(single_wp, (1 / (1 + stan::math::exp((get_base1(EloNow, get_base1(loser_index, i, "loser_index", 1), "EloNow", 1) - get_base1(EloNow, get_base1(winner_index, i, "winner_index", 1), "EloNow", 1))))));
            current_statement_begin__ = 38;
            stan::math::assign(toAdd, ((1 - single_wp) * k));
            current_statement_begin__ = 40;
            stan::model::assign(EloNow, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(winner_index, i, "winner_index", 1)), stan::model::nil_index_list()), 
                        (get_base1(EloNow, get_base1(winner_index, i, "winner_index", 1), "EloNow", 1) + toAdd), 
                        "assigning variable EloNow");
            current_statement_begin__ = 41;
            stan::model::assign(EloNow, 
                        stan::model::cons_list(stan::model::index_uni(get_base1(loser_index, i, "loser_index", 1)), stan::model::nil_index_list()), 
                        (get_base1(EloNow, get_base1(loser_index, i, "loser_index", 1), "EloNow", 1) - toAdd), 
                        "assigning variable EloNow");
        }
        current_statement_begin__ = 44;
        for (int i = 1; i <= (n_ids - 1); ++i) {
            current_statement_begin__ = 45;
            for (int j = (i + 1); j <= n_ids; ++j) {
                current_statement_begin__ = 46;
                stan::math::assign(single_wp, (1 / (1 + stan::math::exp((get_base1(EloNow, i, "EloNow", 1) - get_base1(EloNow, j, "EloNow", 1))))));
                current_statement_begin__ = 47;
                stan::model::assign(pairwise_winprobs, 
                            stan::model::cons_list(stan::model::index_uni(j), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                            single_wp, 
                            "assigning variable pairwise_winprobs");
                current_statement_begin__ = 48;
                stan::model::assign(pairwise_winprobs, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                            (1.0 - single_wp), 
                            "assigning variable pairwise_winprobs");
            }
        }
        current_statement_begin__ = 51;
        for (int i = 1; i <= n_ids; ++i) {
            current_statement_begin__ = 52;
            stan::model::assign(pairwise_winprobs, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                        0.0, 
                        "assigning variable pairwise_winprobs");
            current_statement_begin__ = 53;
            stan::model::assign(cumwinprobs, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        sum(stan::model::rvalue(pairwise_winprobs, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "pairwise_winprobs")), 
                        "assigning variable cumwinprobs");
        }
        current_statement_begin__ = 55;
        return stan::math::promote_scalar<fun_return_scalar_t__>(cumwinprobs);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct cum_winprob_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& EloStart,
                const T1__& k,
                const int& n_interactions,
                const int& n_ids,
                const std::vector<int>& winner_index,
                const std::vector<int>& loser_index, std::ostream* pstream__) const {
        return cum_winprob(EloStart, k, n_interactions, n_ids, winner_index, loser_index, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
cumwinprob2steep(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& nds,
                     const int& n_ids, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 60;
        validate_non_negative_index("A1", "n_ids", n_ids);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> A1(n_ids);
        stan::math::initialize(A1, DUMMY_VAR__);
        stan::math::fill(A1, DUMMY_VAR__);
        current_statement_begin__ = 61;
        validate_non_negative_index("A2", "n_ids", n_ids);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> A2(n_ids);
        stan::math::initialize(A2, DUMMY_VAR__);
        stan::math::fill(A2, DUMMY_VAR__);
        current_statement_begin__ = 62;
        validate_non_negative_index("B1", "n_ids", n_ids);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> B1(n_ids);
        stan::math::initialize(B1, DUMMY_VAR__);
        stan::math::fill(B1, DUMMY_VAR__);
        current_statement_begin__ = 63;
        validate_non_negative_index("AB1", "n_ids", n_ids);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> AB1(n_ids);
        stan::math::initialize(AB1, DUMMY_VAR__);
        stan::math::fill(AB1, DUMMY_VAR__);
        current_statement_begin__ = 65;
        local_scalar_t__ sum_y(DUMMY_VAR__);
        (void) sum_y;  // dummy to suppress unused var warning
        stan::math::initialize(sum_y, DUMMY_VAR__);
        stan::math::fill(sum_y, DUMMY_VAR__);
        current_statement_begin__ = 66;
        local_scalar_t__ sum_x2(DUMMY_VAR__);
        (void) sum_x2;  // dummy to suppress unused var warning
        stan::math::initialize(sum_x2, DUMMY_VAR__);
        stan::math::fill(sum_x2, DUMMY_VAR__);
        current_statement_begin__ = 67;
        local_scalar_t__ sum_x(DUMMY_VAR__);
        (void) sum_x;  // dummy to suppress unused var warning
        stan::math::initialize(sum_x, DUMMY_VAR__);
        stan::math::fill(sum_x, DUMMY_VAR__);
        current_statement_begin__ = 68;
        local_scalar_t__ sum_xy(DUMMY_VAR__);
        (void) sum_xy;  // dummy to suppress unused var warning
        stan::math::initialize(sum_xy, DUMMY_VAR__);
        stan::math::fill(sum_xy, DUMMY_VAR__);
        current_statement_begin__ = 70;
        validate_non_negative_index("theranks", "n_ids", n_ids);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theranks(n_ids);
        stan::math::initialize(theranks, DUMMY_VAR__);
        stan::math::fill(theranks, DUMMY_VAR__);
        current_statement_begin__ = 71;
        int r(0);
        (void) r;  // dummy to suppress unused var warning
        stan::math::fill(r, std::numeric_limits<int>::min());
        current_statement_begin__ = 72;
        int s(0);
        (void) s;  // dummy to suppress unused var warning
        stan::math::fill(s, std::numeric_limits<int>::min());
        current_statement_begin__ = 74;
        validate_non_negative_index("xsteep", "2", 2);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> xsteep(2);
        stan::math::initialize(xsteep, DUMMY_VAR__);
        stan::math::fill(xsteep, DUMMY_VAR__);
        current_statement_begin__ = 77;
        for (int i = 1; i <= n_ids; ++i) {
            current_statement_begin__ = 78;
            stan::math::assign(r, 1);
            current_statement_begin__ = 79;
            stan::math::assign(s, 1);
            current_statement_begin__ = 80;
            for (int j = 1; j <= i; ++j) {
                current_statement_begin__ = 81;
                if (as_bool(logical_lt(get_base1(nds, j, "nds", 1), get_base1(nds, i, "nds", 1)))) {
                    current_statement_begin__ = 82;
                    stan::math::assign(r, (r + 1));
                }
                current_statement_begin__ = 84;
                if (as_bool(logical_eq(get_base1(nds, j, "nds", 1), get_base1(nds, i, "nds", 1)))) {
                    current_statement_begin__ = 85;
                    stan::math::assign(s, (s + 1));
                }
            }
            current_statement_begin__ = 89;
            for (int j = (i + 1); j <= n_ids; ++j) {
                current_statement_begin__ = 90;
                if (as_bool(logical_lt(get_base1(nds, j, "nds", 1), get_base1(nds, i, "nds", 1)))) {
                    current_statement_begin__ = 91;
                    stan::math::assign(r, (r + 1));
                }
                current_statement_begin__ = 93;
                if (as_bool(logical_eq(get_base1(nds, j, "nds", 1), get_base1(nds, i, "nds", 1)))) {
                    current_statement_begin__ = 94;
                    stan::math::assign(s, (s + 1));
                }
            }
            current_statement_begin__ = 97;
            stan::model::assign(theranks, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        ((r + ((s - 1) * 0.5)) - 0.5), 
                        "assigning variable theranks");
        }
        current_statement_begin__ = 101;
        stan::math::assign(sum_y, sum(nds));
        current_statement_begin__ = 102;
        stan::math::assign(sum_x2, 0.0);
        current_statement_begin__ = 103;
        for (int i = 1; i <= n_ids; ++i) {
            current_statement_begin__ = 104;
            stan::math::assign(sum_x2, (sum_x2 + pow(get_base1(theranks, i, "theranks", 1), 2)));
        }
        current_statement_begin__ = 106;
        stan::math::assign(sum_x, sum(theranks));
        current_statement_begin__ = 107;
        stan::math::assign(sum_xy, sum(elt_multiply(nds, theranks)));
        current_statement_begin__ = 109;
        stan::model::assign(xsteep, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                    (((sum_y * sum_x2) - (sum_x * sum_xy)) / ((n_ids * sum_x2) - pow(sum_x, 2))), 
                    "assigning variable xsteep");
        current_statement_begin__ = 112;
        stan::math::assign(A1, subtract(theranks, mean(theranks)));
        current_statement_begin__ = 113;
        stan::math::assign(B1, subtract(nds, mean(nds)));
        current_statement_begin__ = 114;
        stan::math::assign(AB1, elt_multiply(A1, B1));
        current_statement_begin__ = 115;
        stan::math::assign(A2, elt_multiply(A1, A1));
        current_statement_begin__ = 116;
        stan::model::assign(xsteep, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                    (sum(AB1) / sum(A2)), 
                    "assigning variable xsteep");
        current_statement_begin__ = 118;
        return stan::math::promote_scalar<fun_return_scalar_t__>(xsteep);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct cumwinprob2steep_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& nds,
                     const int& n_ids, std::ostream* pstream__) const {
        return cumwinprob2steep(nds, n_ids, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_multi_steep_fixed_sd
  : public stan::model::model_base_crtp<model_multi_steep_fixed_sd> {
private:
        int N;
        int K;
        int n_rand;
        std::vector<std::vector<int> > winner;
        std::vector<std::vector<int> > loser;
        matrix_d presence;
        std::vector<int> y;
public:
    model_multi_steep_fixed_sd(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_multi_steep_fixed_sd(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_multi_steep_fixed_sd_namespace::model_multi_steep_fixed_sd";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 124;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 125;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 1);
            current_statement_begin__ = 126;
            context__.validate_dims("data initialization", "n_rand", "int", context__.to_vec());
            n_rand = int(0);
            vals_i__ = context__.vals_i("n_rand");
            pos__ = 0;
            n_rand = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_rand", n_rand, 1);
            current_statement_begin__ = 127;
            validate_non_negative_index("winner", "N", N);
            validate_non_negative_index("winner", "n_rand", n_rand);
            context__.validate_dims("data initialization", "winner", "int", context__.to_vec(N,n_rand));
            winner = std::vector<std::vector<int> >(N, std::vector<int>(n_rand, int(0)));
            vals_i__ = context__.vals_i("winner");
            pos__ = 0;
            size_t winner_k_0_max__ = N;
            size_t winner_k_1_max__ = n_rand;
            for (size_t k_1__ = 0; k_1__ < winner_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < winner_k_0_max__; ++k_0__) {
                    winner[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t winner_i_0_max__ = N;
            size_t winner_i_1_max__ = n_rand;
            for (size_t i_0__ = 0; i_0__ < winner_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < winner_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "winner[i_0__][i_1__]", winner[i_0__][i_1__], 1);
                }
            }
            current_statement_begin__ = 128;
            validate_non_negative_index("loser", "N", N);
            validate_non_negative_index("loser", "n_rand", n_rand);
            context__.validate_dims("data initialization", "loser", "int", context__.to_vec(N,n_rand));
            loser = std::vector<std::vector<int> >(N, std::vector<int>(n_rand, int(0)));
            vals_i__ = context__.vals_i("loser");
            pos__ = 0;
            size_t loser_k_0_max__ = N;
            size_t loser_k_1_max__ = n_rand;
            for (size_t k_1__ = 0; k_1__ < loser_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < loser_k_0_max__; ++k_0__) {
                    loser[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t loser_i_0_max__ = N;
            size_t loser_i_1_max__ = n_rand;
            for (size_t i_0__ = 0; i_0__ < loser_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < loser_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "loser[i_0__][i_1__]", loser[i_0__][i_1__], 1);
                }
            }
            current_statement_begin__ = 129;
            validate_non_negative_index("presence", "N", N);
            validate_non_negative_index("presence", "K", K);
            context__.validate_dims("data initialization", "presence", "matrix_d", context__.to_vec(N,K));
            presence = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, K);
            vals_r__ = context__.vals_r("presence");
            pos__ = 0;
            size_t presence_j_2_max__ = K;
            size_t presence_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < presence_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < presence_j_1_max__; ++j_1__) {
                    presence(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 130;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
            y = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_i__[pos__++];
            }
            size_t y_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y[i_0__]", y[i_0__], 0);
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 133;
            validate_non_negative_index("EloStart_raw", "n_rand", n_rand);
            validate_non_negative_index("EloStart_raw", "K", K);
            num_params_r__ += (n_rand * K);
            current_statement_begin__ = 134;
            validate_non_negative_index("k", "n_rand", n_rand);
            num_params_r__ += (1 * n_rand);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_multi_steep_fixed_sd() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 133;
        if (!(context__.contains_r("EloStart_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable EloStart_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("EloStart_raw");
        pos__ = 0U;
        validate_non_negative_index("EloStart_raw", "n_rand", n_rand);
        validate_non_negative_index("EloStart_raw", "K", K);
        context__.validate_dims("parameter initialization", "EloStart_raw", "matrix_d", context__.to_vec(n_rand,K));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> EloStart_raw(n_rand, K);
        size_t EloStart_raw_j_2_max__ = K;
        size_t EloStart_raw_j_1_max__ = n_rand;
        for (size_t j_2__ = 0; j_2__ < EloStart_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < EloStart_raw_j_1_max__; ++j_1__) {
                EloStart_raw(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(EloStart_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable EloStart_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 134;
        if (!(context__.contains_r("k")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable k missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        validate_non_negative_index("k", "n_rand", n_rand);
        context__.validate_dims("parameter initialization", "k", "double", context__.to_vec(n_rand));
        std::vector<double> k(n_rand, double(0));
        size_t k_k_0_max__ = n_rand;
        for (size_t k_0__ = 0; k_0__ < k_k_0_max__; ++k_0__) {
            k[k_0__] = vals_r__[pos__++];
        }
        size_t k_i_0_max__ = n_rand;
        for (size_t i_0__ = 0; i_0__ < k_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0.0, k[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable k: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 133;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> EloStart_raw;
            (void) EloStart_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                EloStart_raw = in__.matrix_constrain(n_rand, K, lp__);
            else
                EloStart_raw = in__.matrix_constrain(n_rand, K);
            current_statement_begin__ = 134;
            std::vector<local_scalar_t__> k;
            size_t k_d_0_max__ = n_rand;
            k.reserve(k_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < k_d_0_max__; ++d_0__) {
                if (jacobian__)
                    k.push_back(in__.scalar_lb_constrain(0.0, lp__));
                else
                    k.push_back(in__.scalar_lb_constrain(0.0));
            }
            // transformed parameters
            current_statement_begin__ = 137;
            validate_non_negative_index("EloStart", "n_rand", n_rand);
            validate_non_negative_index("EloStart", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> EloStart(n_rand, K);
            stan::math::initialize(EloStart, DUMMY_VAR__);
            stan::math::fill(EloStart, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 139;
            for (int r = 1; r <= n_rand; ++r) {
                current_statement_begin__ = 140;
                for (int i = 1; i <= K; ++i) {
                    current_statement_begin__ = 141;
                    stan::model::assign(EloStart, 
                                stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (get_base1(EloStart_raw, r, i, "EloStart_raw", 1) - mean(stan::model::rvalue(EloStart_raw, stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "EloStart_raw"))), 
                                "assigning variable EloStart");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 137;
            size_t EloStart_j_1_max__ = n_rand;
            size_t EloStart_j_2_max__ = K;
            for (size_t j_1__ = 0; j_1__ < EloStart_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < EloStart_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(EloStart(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: EloStart" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable EloStart: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            current_statement_begin__ = 147;
            for (int r = 1; r <= n_rand; ++r) {
                current_statement_begin__ = 148;
                lp_accum__.add(normal_log<propto__>(get_base1(k, r, "k", 1), 0, 1));
                current_statement_begin__ = 149;
                lp_accum__.add(normal_log<propto__>(stan::model::rvalue(EloStart_raw, stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "EloStart_raw"), 0, 1));
                current_statement_begin__ = 150;
                lp_accum__.add(bernoulli_log<propto__>(y, ProbFunction(to_vector(stan::model::rvalue(EloStart, stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "EloStart")), get_base1(k, r, "k", 1), presence, N, K, stan::model::rvalue(winner, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(r), stan::model::nil_index_list())), "winner"), stan::model::rvalue(loser, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(r), stan::model::nil_index_list())), "loser"), pstream__)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("EloStart_raw");
        names__.push_back("k");
        names__.push_back("EloStart");
        names__.push_back("steepness");
        names__.push_back("cumwinprobs");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_rand);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_rand);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_rand);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_rand);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_rand);
        dims__.push_back(K);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_multi_steep_fixed_sd_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> EloStart_raw = in__.matrix_constrain(n_rand, K);
        size_t EloStart_raw_j_2_max__ = K;
        size_t EloStart_raw_j_1_max__ = n_rand;
        for (size_t j_2__ = 0; j_2__ < EloStart_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < EloStart_raw_j_1_max__; ++j_1__) {
                vars__.push_back(EloStart_raw(j_1__, j_2__));
            }
        }
        std::vector<double> k;
        size_t k_d_0_max__ = n_rand;
        k.reserve(k_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < k_d_0_max__; ++d_0__) {
            k.push_back(in__.scalar_lb_constrain(0.0));
        }
        size_t k_k_0_max__ = n_rand;
        for (size_t k_0__ = 0; k_0__ < k_k_0_max__; ++k_0__) {
            vars__.push_back(k[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 137;
            validate_non_negative_index("EloStart", "n_rand", n_rand);
            validate_non_negative_index("EloStart", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> EloStart(n_rand, K);
            stan::math::initialize(EloStart, DUMMY_VAR__);
            stan::math::fill(EloStart, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 139;
            for (int r = 1; r <= n_rand; ++r) {
                current_statement_begin__ = 140;
                for (int i = 1; i <= K; ++i) {
                    current_statement_begin__ = 141;
                    stan::model::assign(EloStart, 
                                stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                (get_base1(EloStart_raw, r, i, "EloStart_raw", 1) - mean(stan::model::rvalue(EloStart_raw, stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "EloStart_raw"))), 
                                "assigning variable EloStart");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t EloStart_j_2_max__ = K;
                size_t EloStart_j_1_max__ = n_rand;
                for (size_t j_2__ = 0; j_2__ < EloStart_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < EloStart_j_1_max__; ++j_1__) {
                        vars__.push_back(EloStart(j_1__, j_2__));
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 156;
            validate_non_negative_index("steepness", "n_rand", n_rand);
            Eigen::Matrix<double, Eigen::Dynamic, 1> steepness(n_rand);
            stan::math::initialize(steepness, DUMMY_VAR__);
            stan::math::fill(steepness, DUMMY_VAR__);
            current_statement_begin__ = 157;
            validate_non_negative_index("cumwinprobs", "n_rand", n_rand);
            validate_non_negative_index("cumwinprobs", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> cumwinprobs(n_rand, K);
            stan::math::initialize(cumwinprobs, DUMMY_VAR__);
            stan::math::fill(cumwinprobs, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 158;
            for (int r = 1; r <= n_rand; ++r) {
                current_statement_begin__ = 159;
                stan::model::assign(cumwinprobs, 
                            stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                            to_row_vector(cum_winprob(to_vector(stan::model::rvalue(EloStart, stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "EloStart")), get_base1(k, r, "k", 1), N, K, stan::model::rvalue(winner, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(r), stan::model::nil_index_list())), "winner"), stan::model::rvalue(loser, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(r), stan::model::nil_index_list())), "loser"), pstream__)), 
                            "assigning variable cumwinprobs");
                current_statement_begin__ = 160;
                stan::model::assign(steepness, 
                            stan::model::cons_list(stan::model::index_uni(r), stan::model::nil_index_list()), 
                            get_base1(cumwinprob2steep(to_vector(stan::model::rvalue(cumwinprobs, stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "cumwinprobs")), K, pstream__), 2, "cumwinprob2steep(to_vector(stan::model::rvalue(cumwinprobs, stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), \"cumwinprobs\")), K, pstream__)", 1), 
                            "assigning variable steepness");
            }
            // validate, write generated quantities
            current_statement_begin__ = 156;
            size_t steepness_j_1_max__ = n_rand;
            for (size_t j_1__ = 0; j_1__ < steepness_j_1_max__; ++j_1__) {
                vars__.push_back(steepness(j_1__));
            }
            current_statement_begin__ = 157;
            size_t cumwinprobs_j_2_max__ = K;
            size_t cumwinprobs_j_1_max__ = n_rand;
            for (size_t j_2__ = 0; j_2__ < cumwinprobs_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < cumwinprobs_j_1_max__; ++j_1__) {
                    vars__.push_back(cumwinprobs(j_1__, j_2__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_multi_steep_fixed_sd";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t EloStart_raw_j_2_max__ = K;
        size_t EloStart_raw_j_1_max__ = n_rand;
        for (size_t j_2__ = 0; j_2__ < EloStart_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < EloStart_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "EloStart_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t k_k_0_max__ = n_rand;
        for (size_t k_0__ = 0; k_0__ < k_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t EloStart_j_2_max__ = K;
            size_t EloStart_j_1_max__ = n_rand;
            for (size_t j_2__ = 0; j_2__ < EloStart_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < EloStart_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "EloStart" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t steepness_j_1_max__ = n_rand;
        for (size_t j_1__ = 0; j_1__ < steepness_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "steepness" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t cumwinprobs_j_2_max__ = K;
        size_t cumwinprobs_j_1_max__ = n_rand;
        for (size_t j_2__ = 0; j_2__ < cumwinprobs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < cumwinprobs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cumwinprobs" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t EloStart_raw_j_2_max__ = K;
        size_t EloStart_raw_j_1_max__ = n_rand;
        for (size_t j_2__ = 0; j_2__ < EloStart_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < EloStart_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "EloStart_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t k_k_0_max__ = n_rand;
        for (size_t k_0__ = 0; k_0__ < k_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t EloStart_j_2_max__ = K;
            size_t EloStart_j_1_max__ = n_rand;
            for (size_t j_2__ = 0; j_2__ < EloStart_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < EloStart_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "EloStart" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t steepness_j_1_max__ = n_rand;
        for (size_t j_1__ = 0; j_1__ < steepness_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "steepness" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t cumwinprobs_j_2_max__ = K;
        size_t cumwinprobs_j_1_max__ = n_rand;
        for (size_t j_2__ = 0; j_2__ < cumwinprobs_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < cumwinprobs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cumwinprobs" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_multi_steep_fixed_sd_namespace::model_multi_steep_fixed_sd stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
