% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distr.R
\name{plot_distr}
\alias{plot_distr}
\title{Plot the sampled area}
\usage{
plot_distr(nearestCorner, grid, treelineDf, size = 12)
}
\arguments{
\item{nearestCorner}{A list containing the longitude and the latitude (WGS 84) of the point which is used to load the map.
The values must be of the data type "numeric" and finite.}

\item{grid}{Data frame generated by the function \code{classify_above_treeline} and therefore containing: longitude, latitude
(WGS 84), growing season temperature, growing season length, and a boolean. Longitude and latitude must be of the data type
"numeric" and finite. For the boolean \code{TRUE}, \code{FALSE} and \code{NA} is allowed and
nothing else.}

\item{treelineDf}{A data frame containing line-shaped polygons. Each row containing: a identifier, a start latitude and
longitude, a end latitude and longitude (all WGS 84). All longitude and latitude parameters must be of the type "numeric"
and finite.}

\item{size}{Map zoom, for the "get_map" function of the "ggmap" library. One value, data type "integer", finite and in the range
from 3 to 21.}
}
\value{
Nothing.
}
\description{
With this function it is possible to plot the analyzed area. However you need to register a APIs.
If you are not willing to do this, you cannot plot and the function will throw a warning. See:
\url{https://www.rdocumentation.org/packages/ggmap/versions/3.0.0}.
}
\examples{
\dontrun{
plot_distr(nearestCorner = pointsAboveTreeLine, grid = dfGrid, treelineDf = dfTreeline,
           size = 12)
}
}
\author{
Livio Bätscher, Jurriaan M. de Vos
}
