% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_isInjective}
\alias{Eigen_isInjective}
\title{Check injectivity}
\usage{
Eigen_isInjective(M)
}
\arguments{
\item{M}{a matrix, real or complex}
}
\value{
A Boolean value indicating whether \code{M} represents an injective 
  linear map.
}
\description{
Checks whether a matrix represents an injective linear map 
  (i.e. has trivial kernel).
}
\examples{
set.seed(666L)
M <- matrix(rpois(35L, 1), 5L, 7L)
Eigen_isInjective(M)
}
