% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggestWeights.R
\name{suggestWeights}
\alias{suggestWeights}
\title{Weight suggestions for ECLS-K:2011 data}
\usage{
suggestWeights(
  varnames = NULL,
  data,
  showAllWeightSuggestions = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{varnames}{character vector indicating variables to be included in the weight suggestion.}

\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame},
or an \code{edsurvey.data.frame.list}}

\item{showAllWeightSuggestions}{a logical value. When set to \code{TRUE}, all applicable weights that covers
more components, which typically are more conservative with
smaller sample size, will be returned. By default (i.e., \code{FALSE}), only the most approperate
weight is displayed.}

\item{verbose}{a logical value to either print or suppress status message output.}
}
\value{
A list of weight variables. The first one is the most approperate choice.
}
\description{
Suggest Weights for ECLS-K:2011 data based on inputting variables.
}
\details{
\code{suggestWeights} provides one additional way to assist researchers in deciding which weight to use for analyses.
         This function find the intersect of possible weights given variables provided, and rank this intersect
         based on the number of components a weight can adjust.

         The best weight would adjust for each and every source used and only those sources.
         However, for many analyses, there will be no weight that adjusts for nonresponse
         to all the sources of data that are included and for only those source.
         When no weight corresponds exactly to the combination of components included in the desired analysis,
         researchers might prefer to use a weight that includes nonresponse adjustments for more components
         than they are using in their analysis if that weight also includes
         nonresponse adjustments for the components they are using.

         Researchers should always consult their research questions for optimal weight choice.
}
\examples{
\dontrun{
# read-in ECLS-K:2011 data file with parameters specified
eclsk11 <- readECLS_K2011(path=file.path("~/", "ECLS_K", "2011"), filename = "childK5p.dat",
                           layoutFilename = "ECLSK2011_K5PUF.sps", verbose = FALSE)

# suggest weight for individual variable
suggestWeights(varnames="x8mscalk5", data=eclsk11)

# suggest weight for multiple variables
suggestWeights(varnames=c("x8mscalk5", "x_chsex_r", "x12sesl"), data=eclsk11)
}
}
\references{
Tourangeau, K., Nord, C., Le, T., Sorongon, A.G., Hagedorn, M.C., Daly, P., and Najarian, M. (2015). \emph{Early Childhood Longitudinal Study, Kindergarten Class of 2010-11 (ECLS-K:2011), User's Manual for the ECLS-K:2011 Kindergarten Data File and Electronic Codebook, Public Version} (NCES 2015-074). U.S. Department of Education. Washington, DC: National Center for Education Statistics.

Tourangeau, K., Nord, C., Le, T., Wallner-Allen, K., Hagedorn, M.C., Leggitt, J., and Najarian, M. (2015). \emph{Early Childhood Longitudinal Study, Kindergarten Class of 2010-11 (ECLS-K:2011), User's Manual for the ECLS-K:2011 Kindergarten-First Grade Data File and Electronic Codebook, Public Version} (NCES 2015-078). U.S. Department of Education. Washington, DC: National Center for Education Statistics.

Tourangeau, K., Nord, C., Le, T., Wallner-Allen, K., Vaden-Kiernan, N., Blaker, L. and Najarian, M. (2017). \emph{Early Childhood Longitudinal Study, Kindergarten Class of 2010-11 (ECLS-K:2011) User's Manual for the ECLS-K:2011 Kindergarten-Second Grade Data File and Electronic Codebook, Public Version} (NCES 2017-285). U.S. Department of Education. Washington, DC: National Center for Education Statistics.

Tourangeau, K., Nord, C., Le, T., Wallner-Allen, K., Vaden-Kiernan, N., Blaker, L. and Najarian, M. (2018). \emph{Early Childhood Longitudinal Study, Kindergarten Class of 2010-11 ( ECLS -K:2011) User's Manual for the ECLS-K:2011 Kindergarten-Third G rade Data File and Electronic Codebook, Public Version} (NCES 2018-034). U.S. Department of Education. Washington, DC: National Center for Education Statistics

Tourangeau, K., Nord, C., Le, T., Wallner-Allen, K., Vaden-Kiernan, N., Blaker, L. and Najarian, M. (2018). \emph{Early Childhood Longitudinal Study, Kindergarten Class of 2010-11 (ECLS-K:2011) User's Manual for the ECLS-K:2011 Kindergarten-Fourth Grade Data File and Electronic Codebook, Public Version} (NCES 2018-032). U.S. Department of Education. Washington, DC: National Center for Education Statistics.

Tourangeau, K., Nord, C., Le, T., Wallner-Allen, K., Vaden-Kiernan, N., Blaker, L. and Najarian, M. (2019). \emph{Early Childhood Longitudinal Study, Kindergarten Class of 2010-11 (ECLS-K:2011) User's Manual for the ECLS-K:2011 Kindergarten-Fifth Grade Data File and Electronic Codebook, Public Version} (NCES 2019-051). U.S. Department of Education. Washington, DC: National Center for Education Statistics.
}
\author{
Huade Huo
}
