% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadECLS_K.R
\name{downloadECLS_K}
\alias{downloadECLS_K}
\title{Download and Unzip ECLS_K Files}
\usage{
downloadECLS_K(root, years = c(1998, 2011), cache = FALSE, verbose = TRUE)
}
\arguments{
\item{root}{a character string indicating the directory where the ECLS_K
data should be stored. Files are placed in a
subdirectory named ECLS_K/[year].}

\item{years}{an integer vector of the assessment years to download. Valid years are 1998 and 2011.}

\item{cache}{a logical value set to process and cache the text (.txt) version of files.
This takes a very long time but saves time for future uses of 
the data. Default value is \code{FALSE}.}

\item{verbose}{a logical value to either print or suppress status message output.
The default value is \code{TRUE}.}
}
\description{
Uses an Internet connection to download ECLS_K data. 
             Data come from \href{https://nces.ed.gov/edat/}{nces.ed.gov} zip files. This
             function works for 1998 and 2011 data.
}
\details{
Beginning for the ECLS_K 2011 Study Grade 5 data files, the \code{ChildK5p.zip} source data file is a \code{DEFLATE64} compressed zip file.
This means that the user must manually extract the contained \code{childK5p.dat} file using an external zip
program capable of handling \code{DEFLATE64} zip format. As existing R functions are unable to handle this zip format natively.
}
\examples{
\dontrun{
# root argument will vary by operating system conventions
downloadECLS_K(years=c(1998, 2011), root = "~/")

# cache=TRUE will download then process the datafiles
downloadECLS_K(years=c(1998, 2011), root = "~/", cache = TRUE)

# set verbose=FALSE for silent output
# if year not specified, download all years
downloadECLS_K(root="~/", verbose = FALSE)
}
}
\seealso{
\code{\link{readECLS_K1998}} and \code{\link{readECLS_K2011}}
}
\author{
Tom Fink
}
