% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNAEP.r
\name{readNAEP}
\alias{readNAEP}
\title{Creates an edsurvey.data.frame.}
\usage{
readNAEP(filepath, defaultWeight = "origwt", defaultPvs = "composite",
  omittedLevels = c("Multiple", NA, "Omitted"), frPath = NULL)
}
\arguments{
\item{filepath}{character indicating the location and name of the file.}

\item{defaultWeight}{character that indicates the default weight.}

\item{defaultPvs}{character that indicates the default plausible value.}

\item{omittedLevels}{character vector indicating which factor levels (really, labels)
should be excluded. When set to the default value of c('Multiple',NA,'Omitted'), adds the vector to the \code{edsurvey.data.frame}.}

\item{frPath}{character indicating the location of the fr2 parameter file included with the data companion.}
}
\value{
An \code{edsurvey.data.frame} containing the following elements:
   \item{userConditions}{A list containing all user conditions set using the \code{subset.edsurvey.data.frame} method.}
   \item{defaultConditions}{The default conditions to be applied to the \code{edsurvey.data.frame}.}
   \item{data}{An \code{LaF} object containing a connection the student data set on disk.}
   \item{dataSch}{An \code{LaF} object containing a connection the school data set on disk.}
   \item{weights}{A list containing the weights found on the \code{edsurvey.data.frame}.}
   \item{pvvar}{A list containing the plausible values found on the \code{edsurvey.data.frame}.}
   \item{subject}{The subject of the data set contained in the \code{edsurvey.data.frame}.}
   \item{year}{The year of assessment of the data set contained in the \code{edsurvey.data.frame}.}
   \item{assessmentCode}{The code of the data set contained in the \code{edsurvey.data.frame}.}
   \item{dataType}{The type of data (whether student or school) contained in the \code{edsurvey.data.frame}.}
   \item{gradeLevel}{The grade of the data set contained in the \code{edsurvey.data.frame}.}
   \item{achievementLevels}{Default NAEP achievement cutoff scores.}
   \item{omittedLevels}{The levels of the factor variables that will be omitted from the \code{edsurvey.data.frame}.}
   \item{fileFormat}{A \code{data.frame} containing the parsed information from the student .fr2 file associated with the data.}
   \item{fileFormatSchool}{A \code{data.frame} containing the parsed information from the school .fr2 file associated with the data.}
   \item{survey}{The type of survey data contained in the \code{edsurvey.data.frame}.}
}
\description{
Opens a connection to the data file residing on the disk and returns information about the file and data.
}
\details{
The function uses precompiled label information for data to read in a fixed-width format file, and uses prestored data
         to get information about the file.
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))
sdf

\dontrun{
# To read in an NCES file first set the directory to the ~/Data subfolder,
# then read in the appropriate .dat file:
setwd("location/of/Data")
sdf <- readNAEP(filepath="M36NT2PM.dat")

# Or read in the .dat file directly through the folder pathway:
sdf <- readNAEP(filepath="location/of/Data/M36NT2PM.dat")
}
}
\author{
Ahmad Emad
}
