% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustergram.R
\name{clustergram.vegclust}
\alias{clustergram.vegclust}
\title{Vegclust function for clustergram}
\usage{
clustergram.vegclust(Data, k, method = method, ...)
}
\arguments{
\item{Data}{Should be a scales matrix. Where each column belongs to a
different dimension of the observations.}

\item{k}{Number of desired groups for the FCM clustering.}

\item{method}{Clustering method for the vegclust function.}

\item{...}{Additional parameters to be passed to the vegclust function.}
}
\value{
A list containing the cluster vector and the centers matrix (see
  vegclust function).
}
\description{
Vegclust function for clustergram
}
\details{
This is an implementation of Fuzzy c-means clustering (with the
  vegclust function of the vegclust package) for the clustergram function.
  The return list is internally used by the clustergram to build the
  clustergram plot.
}
\examples{
\donttest{
  ####### Example data:
   SyntheticTrial <- SyntheticData(SpeciesNum = 100,
                                   CommunityNum = 3, SpCo = NULL,
                                   Length = 500,
                                   Parameters = list(a=c(40, 80, 50),
                                                     b=c(100,250,400),
                                                     c=rep(0.03,3)),
                                   dev.c = .015, pal = c("#008585", "#FBF2C4", "#C7522B"))

   ######## clustergram plot
   clustergram(as.matrix(SyntheticTrial[,2:ncol(SyntheticTrial)]),
                              clustering.function = clustergram.vegclust,
                              k.range = 2:10, line.width = .2)
 }

}
