% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.subset.R
\name{eco.subset}
\alias{eco.subset}
\title{Subsetting an ecogen object by group}
\usage{
eco.subset(eco, hier, grp, missing = c("0", "NA", "MEAN"))
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{hier}{The name of the S slot column containing labels assigning individuals to groups.}

\item{grp}{Label shared by the subset of individuals, contained in hier.}

\item{missing}{Missing data argument It can take three values ("0", "NA" or "MEAN"),
as described in  \code{\link{ecogen}}.
Missing elements are treated as zeros in the default option.}
}
\description{
Subsetting an ecogen object by group
}
\examples{
\dontrun{
data(eco3)
eco3
eco.sub <-eco.subset(eco3,"structure", 1) 
eco.sub
}

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
