% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eco.2genepop.R
\name{eco.2genepop}
\alias{eco.2genepop}
\title{Exporting an ecogen genetic data frame into Genepop format}
\usage{
eco.2genepop(eco, grp = NULL, ndig, name = "infile.genepop.txt")
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{grp}{The name of the @S slot column with groups in which the sample
must be divided (e.g., populations). If groups are not given (grp = NULL),
all individuals will be assigned to a single one.}

\item{ndig}{Number of digits coding each allele (1: x, 2: xx or
3:xxx) when there is more than one allele per individual locus.}

\item{name}{The name of the output file.}
}
\value{
A Genepop file in the working directory.
}
\description{
This function converts the genetic
data of an ecogen object in a Genepop input file.
}
\examples{
\dontrun{

data(eco.test)
eco.2genepop(eco, grp = "pop", ndig = 1, name = "infile.genepop.txt")
# an output file "infile.genepop.txt" is generated in the working directory
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

