% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec_extract_env_layers.R
\name{ec_extract_env_layers}
\alias{ec_extract_env_layers}
\title{Extract the Environmental data}
\usage{
ec_extract_env_layers(
  data,
  env_layers = env_layers,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude"
)
}
\arguments{
\item{data}{data table which has coordinate information}

\item{env_layers}{make a list of enviornmental layers which need to be extracted, example :BO_sstmean, BO_sstmax, BO_sstmin, BO_chomean, BO_phosphate or marspec layer, must check list_layer to know exact name of the layer code.}

\item{latitude}{default assigned as "decimalLatitude"}

\item{longitude}{default assigned as "decimalLongitude"}
}
\value{
A data table which has unique coordinates and env predictors
}
\description{
Extract the Environmental data
}
\examples{
\dontrun{
env_layers <- c("BO_sstmean", "BO_chlomean", "BO_dissox", "BO_salinity")
data <- data.frame(
  scientificName = "Mexacanthina lugubris",
  decimalLongitude = c(-117, -117.8, -116.9),
  decimalLatitude = c(32.9, 33.5, 31.9)
)

data_x <- ec_extract_env_layers(data,
  env_layers = env_layers,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude"
)
}
}
