% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{evalplot.stats}
\alias{evalplot.stats}
\title{ENMevaluation statistics plot}
\usage{
evalplot.stats(
  e,
  stats,
  x.var,
  color.var,
  dodge = NULL,
  error.bars = TRUE,
  facet.labels = NULL,
  metric.levels = NULL,
  return.tbl = FALSE
)
}
\arguments{
\item{e}{ENMevaluation object}

\item{stats}{character vector: names of statistics from results table to be plotted; if more than
one statistic is specified, the plot will be faceted}

\item{x.var}{character: variable to be plotted on x-axis}

\item{color.var}{character: variable used to assign symbology colors}

\item{dodge}{numeric: dodge width for points and lines; this improves visibility when there is high overlap (optional)}

\item{error.bars}{boolean: if TRUE, plot error bars}

\item{facet.labels}{character vector: custom names for the metric facets}

\item{metric.levels}{character vector: custom factor levels for metrics; this controls the order that metric statistics are plotted}

\item{return.tbl}{boolean: if TRUE, return the data frames of results used to make the ggplot instead of the plot itself}
}
\value{
A ggplot of evaluation statistics.
}
\description{
Plot evaluation statistics over tuning parameter ranges to visualize differences in performance
}
\details{
In this plot, the x-axis represents a tuning parameter range, while the y-axis represents the average of a statistic over all partitions.
Different colors represent the categories or values of another tuning parameter. 
Error bars represent the standard deviation of a statistic around the mean. 
Currently, this function can only plot two tuning parameters at a time.
}
\examples{
\dontrun{
# first, let's tune some models
occs <- read.csv(file.path(system.file(package="predicts"), 
"/ex/bradypus.csv"))[,2:3]
envs <- rast(list.files(path=paste(system.file(package="predicts"), 
"/ex", sep=""), pattern="tif$", full.names=TRUE))
bg <- as.data.frame(predicts::backgroundSample(envs, n = 10000))
names(bg) <- names(occs)
 
ps <- list(orientation = "lat_lat")
e <- ENMevaluate(occs, envs, bg, 
               tune.args = list(fc = c("L","LQ","LQH"), rm = 1:5), 
               partitions = "block", partition.settings = ps, 
               algorithm = "maxnet", categoricals = "biome", 
               parallel = TRUE)
               
evalplot.stats(e, c("cbi.val", "or.mtp"), x.var = "rm", color.var = "fc", 
             error.bars = FALSE)
}
}
