\name{calc.niche.overlap}
\alias{calc.niche.overlap}
\title{ Calculate Similarity of ENMs in Geographic Space }

\description{
Compute pairwise "niche overlap" in geographic space for Maxent predictions. The value ranges from 0 (no overlap) to 1 (identical predictions).  The function uses the \code{nicheOverlap} function of the \pkg{dismo} package (Hijmans \emph{et al.} 2011).
}

\usage{ calc.niche.overlap(predictive.maps, stat = "D", maxent.args) }

\arguments{
\item{predictive.maps}{ A rasterStack of at least 2 Maxent predictive raster layers. }

\item{stat}{ The statistic calculated by the \code{nicheOverlap} function of the \pkg{dismo} package.  Defaults to Schoener's \emph{D} (Schoener 1968) but can also accept \code{"I"} to calculate the \emph{I} similarity statistic from Warren \emph{et al.} (2008). }

\item{maxent.args}{ A list of (1) feature classes, and (2) regularization multiplier values that describe model settings for each predictive map provided in \code{predictive.maps}.  This is generated by the function \code{\link{make.args}(..., labels=TRUE)}. }

}
\value{ A matrix with the lower triangle giving values of pairwise "niche overlap" in geographic space.  Row and column names are given by the \code{\link{make.args}} argument when run by the \code{\link{ENMevaluate}} function. }

\references{
Hijmans, R. J., Phillips, S., Leathwick, J. and Elith, J. (2011) dismo package for R. Available online at: \url{https://cran.r-project.org/package=dismo}.
	
Schoener, T. W. (1968) The \emph{Anolis} lizards of Bimini: resource partitioning in a complex fauna. \emph{Ecology}, \bold{49}: 704-726.
	
Warren, D. L., Glor, R. E., Turelli, M. and Funk, D. (2008) Environmental niche equivalency versus conservatism: quantitative approaches to niche evolution. \emph{Evolution}, \bold{62}: 2868-2883.
}

\author{ Based on \pkg{dismo}::\code{nicheOverlap}, which is based on \pkg{SDMTools}::\code{Istat}
	
Robert Muscarella <bob.muscarella@gmail.com> }
\seealso{
\code{\link{make.args}}; \code{nicheOverlap} in the \pkg{dismo} package
}
