% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_methods.R
\name{set_methods}
\alias{set_methods}
\title{set_methods}
\usage{
set_methods(
  methods_file,
  instrumentation = character(),
  software = NULL,
  sampling_file = NULL,
  sampling_coverage = NULL,
  sampling_citation = NULL,
  qualityControl_file = NULL
)
}
\arguments{
\item{methods_file}{Path to a file (markdown or .docx) containing a description of the methods used}

\item{instrumentation}{optional, text describing instrumentation used in methods}

\item{software}{optional, an EML software node describing software used in methods}

\item{sampling_file}{optional, Path to a file (.md or .docx) describing sampling method}

\item{sampling_coverage}{optional, coverage node for methods, e.g. set_coverage()}

\item{sampling_citation}{optional, a citation element describing the sampling protocol}

\item{qualityControl_file}{optional, path to a file (.md or .docx) describing quality control methods}
}
\value{
A methods object
}
\description{
set_methods
}
\examples{
\donttest{
f <- system.file("examples/hf205-methods.md", package = "EML")
set_methods(methods_file = f)

## Can also import from methods written in a .docx MS Word file.
f <- system.file("examples/hf205-methods.docx", package = "EML")
set_methods(methods_file = f)
}
}
