% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRI.R
\name{reshape_events}
\alias{reshape_events}
\title{Reshape events data for fMRI analysis}
\usage{
reshape_events(events, event_types, duration = 0.001, modulation = NULL)
}
\arguments{
\item{events}{A data frame containing event information with required columns 'subjects', 'run', and 'onset'}

\item{event_types}{A character vector of column names in the events data frame to be treated as event_types}

\item{duration}{Either a single numeric value (applied to all event_types), a list with named elements
corresponding to event_types, or a function that takes the events data frame and returns durations}

\item{modulation}{Either a list with named elements corresponding to event_types, or a function that takes
the events data frame and returns durations}
}
\value{
A data frame with columns 'subjects', 'onset', 'run', 'modulation', 'duration', and 'event_type'
}
\description{
This function reshapes event data into a format suitable for fMRI analysis by
converting specified event_types into separate event types with appropriate modulation values.
}
\examples{
# Create a simple events data frame
events <- data.frame(
  subjects = rep(1, 10),
  run = rep(1, 10),
  onset = seq(0, 90, by = 10),
  condition = rep(c("A", "B"), 5),
  rt = runif(10, 0.5, 1.5),
  accuracy = sample(0:1, 10, replace = TRUE)
)

# Reshape with default duration
reshaped1 <- reshape_events(events, event_types = c("condition", "accuracy"))

# Reshape with custom duration for each event_type
reshaped2 <- reshape_events(events,
                           event_types = c("condition", "accuracy", "rt"),
                           duration = list(condition = 0.5,
                                          accuracy = 0.2,
                                          rt = function(x) x$rt))
}
