% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme.dscore.R
\name{lme.dscore}
\alias{lme.dscore}
\title{Calculate d scores from an lme4 or nlme object}
\usage{
lme.dscore(mod, data, type)
}
\arguments{
\item{mod}{An lme4 or nlme object}

\item{data}{The dataset the lme4 or nlme object was drawn from}

\item{type}{Either "lme4" or "nlme"}
}
\value{
A table of d-scores.
}
\description{
This will calculate Cohen's D for each effect in an lme4 object.
}
\note{
lme4 and nlme models will produce slightly different estimates. This is because when using type="lme4", the numerator DF will be calculated using the Satterthwaite approximations to degrees of freedom (via the lmerTest package), whereas nlme includes Kenward-Roger numerator degress of freedom. If you have sufficent level-1 samples, the difference between models will be miniscule.
}
\examples{
\dontrun{model1<-lmer(DV~IV1+IV2+IV3+(1|subject),data=DATA_1)}
 \dontrun{lme.dscore(model1,data=DATA_1,type="lme4")}
}
\keyword{Cohen's}
\keyword{D}
