% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd9toPheWAS.R
\name{icd9toPheWAS}
\alias{icd9toPheWAS}
\title{Function to transform ICD9-CM codification into PheWAS code}
\usage{
icd9toPheWAS(data, icd9ColumnName, missingValues = "NA",
  phecodeDescription = FALSE, statistics = FALSE,
  replaceColumn = TRUE, verbose = FALSE)
}
\arguments{
\item{data}{A \code{data.frame} object with at least one column of ICD9-CM codes that
one to be transformed into a PheWAS code.}

\item{icd9ColumnName}{The name of the column containing the ICD9-CM.}

\item{missingValues}{The value used to determine missing values in the data.frame.}

\item{phecodeDescription}{By default \code{FALSE}. Change it to \code{TRUE} to map
to the PheWAS code description instead to the PheWAS numeric code.}

\item{statistics}{By default \code{FALSE}. Change it to \code{TRUE} to show the 
summary of the mapping like the percentage of initial ICD9-CM codes mapped to PheWAS code.}

\item{replaceColumn}{By default \code{TRUE}. Change it to \code{FALSE} in order to create a
new column with the PheWAS code maintaining the ICD9-CM code.}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get an
on-time log from the function.}
}
\value{
An object of class \code{data.frame} with the ICD9-CM column transform into
PheWAS codes.
}
\description{
Given a  \code{data.frame} object with a column of ICD9-CM codes, it generates a 
new \code{data.frame} object with the ICD9-CM codes transformed into PheWAS codes.
}
\examples{
dataset <- read.csv2(system.file("extdata",
                                   "nhdsSubset.csv",
                                   package="EHRtemporalVariability"), 
                     sep  = ",",
                     header = TRUE, 
                     na.strings = "", 
                     colClasses = c( "character", "numeric", "factor",
                                     "numeric" , rep( "factor", 22 ) ) )

datasetPheWAS <- icd9toPheWAS( data           = dataset,
                              icd9ColumnName  = "diagcode1", 
                              missingValues   = "N/A", 
                              statistics      = TRUE 
                              )
}
