% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modelEstimation.R
\name{estFNsegs}
\alias{estFNsegs}
\title{Segment estimates}
\usage{
estFNsegs(eList, segStart_i, segEnd_i, dStart_i, dEnd_i)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{segStart_i}{integer vector of start years (water) for each FN conc/flux segment}

\item{segEnd_i}{integer vector of end years (water) for each FN conc/flux segment}

\item{dStart_i}{Date vector of start days for each flow segment}

\item{dEnd_i}{Date vector of end days for each flow segment}
}
\description{
Segment estimates
}
\examples{
eList <- Choptank_eList
eList <- setUpEstimation(eList)
nSegments <- 2
segStart <- c(1985,2000)
segEnd <- c(2001,2010)
dStart <- as.Date(c("1988-10-01","2002-05-15"))
dEnd <- as.Date(c("1998-09-30","2009-09-30"))
eList <- estFNsegs(eList,segStart[1],segEnd[1],dStart[1],dEnd[1])
}

