% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infoCluster.R
\name{infoCluster}
\alias{infoCluster}
\title{Information Theoretic Mixture Clustering for \code{\link[EGAnet]{dynEGA}}}
\usage{
infoCluster(dynEGA.object, plot.cluster = TRUE)
}
\arguments{
\item{dynEGA.object}{A \code{\link[EGAnet]{dynEGA}} or a
\code{\link[EGAnet]{dynEGA.ind.pop}} object that is used to match the arguments of the EII object.}

\item{plot.cluster}{Boolean.
Should plot of optimal and hierarchical clusters be output?
Defaults to \code{TRUE}.
Set to \code{FALSE} to not plot}
}
\value{
Returns a list containing:

\item{clusters}{A vector corresponding to cluster each participant belongs to}

\item{clusterTree}{The dendogram from \code{\link[stats]{hclust}} the hierarhical clustering}

\item{clusterPlot}{Plot output from results}

\item{JSD}{Jensen-Shannon Distance}
}
\description{
Performs hierarchical clustering using Jensen-Shannon distance
followed by the Louvain algorithm with consensus clustering. The method
iteratively identifies smaller and smaller clusters until there is no
change in the clusters identified
}
\examples{
# Obtain data
sim.dynEGA <- sim.dynEGA # bypasses CRAN checks

\donttest{# Dynamic EGA individual and population structure
dyn.ega1 <- dynEGA.ind.pop(
  data = sim.dynEGA, n.embed = 5, tau = 1,
  delta = 1, id = 21, use.derivatives = 1, 
  ncores = 2, corr = "pearson"
)

# Perform information-theoretic clustering
clust1 <- infoCluster(
  dynEGA.object = dyn.ega1,
  plot.cluster = FALSE # No plot for CRAN checks
)}

}
\author{
Hudson Golino <hfg9s at virginia.edu> & Alexander P. Christensen <alexander.christensen at Vanderbilt.Edu>
}
