% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.bfi.R
\docType{data}
\name{data.bfi}
\alias{data.bfi}
\title{25 Personality Items Representing 5 Factors}
\format{
A data frame with 2,800 observations on 28 variables. The variables include:
\itemize{
  \item \code{A1} - Am indifferent to the feelings of others. (q_146)
  \item \code{A2} - Inquire about others’ well-being. (q_1162)
  \item \code{A3} - Know how to comfort others. (g_1206)
  \item \code{A4} - Love children. (g_1364)
  \item \code{A5} - Make people feel at ease. (q_1419)
  \item \code{C1} - Am exacting in my work. (q_124)
  \item \code{C2} - Continue until everything is perfect. (q_530)
  \item \code{C3} - Do things according to a plan. (q_619)
  \item \code{C4} - Do things in a half-way manner. (g_626)
  \item \code{C5} - Waste my time. (g_1949)
  \item \code{E1} - Don't talk a lot. (q_712)
  \item \code{E2} - Find it difficult to approach others. (q_901)
  \item \code{E3} - Know how to captivate people. (q_1205)
  \item \code{E4} - Make friends easily. (q_1410)
  \item \code{E5} - Take charge. (g_1768)
  \item \code{N1} - Get angry easily. (q_952)
  \item \code{N2} - Get irritated easily. (q_974)
  \item \code{N3} - Have frequent mood swings. (q_1099)
  \item \code{N4} - Often feel blue. (g_1479)
  \item \code{N5} - Panic easily. (q_1505)
  \item \code{O1} - Am full of ideas. (q_128)
  \item \code{O2} - Avoid difficult reading material. (g_316)
  \item \code{O3} - Carry the conversation to a higher level. (q_492)
  \item \code{O4} - Spend time reflecting on things. (g_1738)
  \item \code{O5} - Will not probe deeply into a subject. (q_1964)
  \item \code{gender} - Gender: Males = 1, Females = 2
  \item \code{education} - Education level: 1 = High School, 2 = Finished High School,
    3 = Some College, 4 = College Graduate, 5 = Graduate Degree
  \item \code{age} - Age in years
}
}
\source{
The items are from the ipip (Goldberg, 1999). The data are from the SAPA project (Revelle, Wiltand Rosenthal, 2010),
collected Spring, 2010(https://www.sapa-project.org/).
}
\description{
This dataset includes 25 self-report personality items sourced from the International Personality Item Pool
(ipip.ori.org) as part of the Synthetic Aperture Personality Assessment (SAPA) web-based personality
assessment project. The dataset contains responses from 2,800 examinees. Additionally, three
demographic variables (sex, education, and age) are included.
}
\details{
The 25 items are organized by five factors: Agreeableness, Conscientiousness, Extraversion,
Neuroticism, and Openness. The scoring key is created using \code{make.keys}, and scores are
calculated using \code{score.items}. These factors are useful for IRT-based latent factor analysis
of the polychoric correlation matrix. Endorsement plots and item information functions reveal
variations in item quality. Responses were collected on a 6-point scale:
1 = Very Inaccurate, 2 = Moderately Inaccurate, 3 = Slightly Inaccurate, 4 = Slightly Accurate,
5 = Moderately Accurate, 6 = Very Accurate, as part of the Synthetic Aperture Personality Assessment (SAPA)
project (https://www.sapa-project.org/). For examples of data collection techniques, visit
https://www.sapa-project.org/ or the International Cognitive Ability Resource at
https://icar-project.org. The items were sampled from the International Personality Item Pool of
Lewis Goldberg using SAPA sampling techniques. This dataset is a sample from the larger SAPA data bank.
}
\note{
The data.bfi data set and items should not be confused with the BFI (Big Five Inventory) of Oliver Johnand colleagues (John, O. P,
Donahue, E. M., & Kentle, R.L. (1991). The Big Five Inventory Versions 4a and 54. Berkeley, CA: University of California,
Berkeley, Institute of Personality and Social Research.)
}
\examples{
data(data.bfi)
head(data.bfi)

}
\references{
Goldberg, L.R. (1999). A broad-bandwidth, public domain, personality inventory measuring the lower-level facets of several five-factor models. In Mervielde, I., Deary, I., De Fruyt, F., & Ostendorf, F. (Eds.), Personality psychology in Europe (Vol. 7, pp. 7-28). Tilburg University Press.

Revelle, W., Wilt, J., & Rosenthal, A. (2010). Individual Differences in Cognition: New Methods for Examining the Personality-Cognition Link. In Gruszka, A., Matthews, G., & Szymura, B. (Eds.), Handbook of Individual Differences in Cognition: Attention, Memory and Executive Control (pp. 117-144). Springer.

Revelle, W., Condon, D., Wilt, J., French, J.A., Brown, A., & Elleman, L.G. (2016). Web and phone-based data collection using planned missing designs. In Fielding, N.G., Lee, R.M., & Blank, G. (Eds.), SAGE Handbook of Online Research Methods (2nd ed., pp. 100-116). Sage Publications.
}
