% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.bootstrap.R
\name{gof.bootstrap}
\alias{gof.bootstrap}
\alias{gof.uniform.bootstrap}
\alias{gof.normal.bootstrap}
\alias{gof.gamma.bootstrap}
\alias{gof.logistic.bootstrap}
\alias{gof.laplace.bootstrap}
\alias{gof.weibull.bootstrap}
\alias{gof.extremevalue.bootstrap}
\alias{gof.exp.bootstrap}
\title{Generic GOF tests based on EDF using bootstrap}
\usage{
gof.uniform.bootstrap(x, M = 10000)

gof.normal.bootstrap(x, M = 10000)

gof.gamma.bootstrap(x, M = 10000)

gof.logistic.bootstrap(x, M = 10000)

gof.laplace.bootstrap(x, M = 10000)

gof.weibull.bootstrap(x, M = 10000)

gof.extremevalue.bootstrap(x, M = 10000)

gof.exp.bootstrap(x, M = 10000)
}
\arguments{
\item{x}{A random sample.}

\item{M}{Number of bootstrap, 10000 by default.}
}
\value{
Cramér-von Mises, Anderson-Darling and Watson statistics and their P-values.
}
\description{
This function takes in an i.i.d. random sample, use MLE to estimate parameters of
the assumed distribution, compute probability integral transforms, and computes Cramér-von Mises,
Anderson-Darling and Watson statistics and their P-values using bootstrap method.
}
\examples{
x0=runif(n=100,min=-1,max=1)
gof.uniform.bootstrap(x0,M=100)

x1=rnorm(n=100,mean=0,sd=1)
gof.normal.bootstrap(x1,M=100)

x2=rgamma(n=100,shape=1,scale=1)
gof.gamma.bootstrap(x2,M=100)

x3=rlogis(n=100,location=0,scale=1)
gof.logistic.bootstrap(x3,M=100)

x4= rmutil::rlaplace(n=100,m=0,s=1)
gof.laplace.bootstrap(x4,M=100)

x5=rweibull(n=100,shape=1,scale=1)
gof.weibull.bootstrap(x5,M=100)
x5_log=log(x5)
gof.extremevalue.bootstrap(x5_log,M=100)

x6=rexp(n=100,rate=1/2)
gof.exp.bootstrap(x6,M=100)
}
\seealso{
\code{\link{gof.sandwich}} for general distributions using Sandwich estimation
  of covariance function;
\code{\link{gof}} for generic functions using \code{\link[CompQuadForm]{imhof}} function.
}
