% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EB_CS.R
\name{EB_CS}
\alias{EB_CS}
\title{Main function used in the paper (Du and Hu, 2020)}
\usage{
EB_CS(
  x,
  df,
  qq = c(0.2, 0.4, 0.6, 0.8),
  method = c("LS", "PLS", "g_model"),
  mixture = FALSE
)
}
\arguments{
\item{x}{a sequence of chi-squared test statistics}

\item{df}{the degrees of freedom}

\item{qq}{the quantiles used in spline basis}

\item{method}{LS: parametric least-squares; PLS: penalized least-squares; g-model: g-modeling}

\item{mixture}{default is FALSE: there is no point mass at zero.}
}
\value{
a list: posterior mean, variance, and skewness estimates
}
\description{
Give a sequence of chi-squared statistic values, the function computes the posterior mean, variance, and skewness
of the noncentrality parameter given the data.
}
\examples{
p = 1000
k = 7
# the prior distribution for lambda
alpha = 2
beta =  10
# lambda
lambda = rep(0, p)
pi_0 = 0.8
p_0 = floor(p*pi_0)
p_1 = p-p_0
lambda[(p_0+1):p] = rgamma(p_1, shape = alpha, rate=1/beta)
# Generate a Poisson RV
J = sapply(1:p, function(x){rpois(1, lambda[x]/2)})
X = sapply(1:p, function(x){rchisq(1, k+2*J[x])})
qq_set = seq(0.01, 0.99, 0.01)
out = EB_CS(X, k, qq=qq_set, method='LS', mixture = TRUE)
E = out$E_lambda
V = out$V_lambda
S = out$S_lambda

}
\references{
Du and Hu (2020), \emph{An Empirical Bayes Method for Chi-Squared Data}, \emph{Journal of American Statistical Association}, forthcoming.
}
