% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B_TxSubsetFactor.R
\name{TxSubsetFactor-methods}
\alias{TxSubsetFactor-methods}
\alias{.convertFromBinary,TxSubsetFactor-method}
\alias{.convertToBinary,TxSubsetFactor-method}
\alias{.getPtsSubset,TxSubsetFactor-method}
\alias{.getSingleton,TxSubsetFactor-method}
\alias{.getSubsetRule,TxSubsetFactor-method}
\alias{.getSubsets,TxSubsetFactor-method}
\alias{.compareTx,TxSubsetFactor,factor,factor-method}
\alias{.convertTx,TxSubsetFactor-method}
\alias{.getLevels,TxSubsetFactor,factor-method}
\alias{.getSuperset,TxSubsetFactor-method}
\alias{.getTxName,TxSubsetFactor-method}
\alias{.validTx,TxSubsetFactor-method}
\title{Methods Available for Objects of Class \code{TxSubsetFactor}}
\usage{
\S4method{.convertFromBinary}{TxSubsetFactor}(txObj, ..., txVec)

\S4method{.convertToBinary}{TxSubsetFactor}(txObj, ..., txVec, data)

\S4method{.getPtsSubset}{TxSubsetFactor}(object)

\S4method{.getSingleton}{TxSubsetFactor}(object)

\S4method{.getSubsetRule}{TxSubsetFactor}(object)

\S4method{.getSubsets}{TxSubsetFactor}(object)

\S4method{.compareTx}{TxSubsetFactor,factor,factor}(object, vec1, vec2)

\S4method{.convertTx}{TxSubsetFactor}(object, txVec)

\S4method{.getLevels}{TxSubsetFactor,factor}(object, txVec)

\S4method{.getSuperset}{TxSubsetFactor}(object)

\S4method{.getTxName}{TxSubsetFactor}(object)

\S4method{.validTx}{TxSubsetFactor}(object, txVec)
}
\description{
Methods Available for Objects of Class \code{TxSubsetFactor}

\code{.convertFromBinary(txObj, txVec)}
  converts a -1/1 Tx to user provided tx coding.
  Call method defined for \code{TxSubset}.

\code{.convertToBinary(txObj, data)}
  converts user specified tx variable to binary -1/1.
  Call method defined for \code{TxSubset}.

\code{.getPtsSubset(object)}
 retrieve subset name for which each pt is a member.
  Call method defined for \code{TxSubset}.

\code{.getSingleton(object)}
  retrieve T/F indicator of only 1 tx option available to each pt.
  Call method defined for \code{TxSubset}.

\code{.getSubsetRule(object)}
  retrieve feasible set identification rule.
  Call method defined for \code{TxSubset}.

\code{.getSubsets(object)}
  retrieve subset names and tx options.
  Call method defined for \code{TxSubset}.

\code{.compareTx(object, vec1, vec2)}
  compares vec1 and vec2 to identify equivalent elements.

\code{.compareTx(object, vec1, vec2)}
  converts txVec to factor.

\code{.getLevels(object, txVec)}
  determines tx levels contains in txVec.

\code{.getSuperset(object)}
  retrieves superset. Uses method defined for TxInfoFactor objects.

\code{.getTxName(object)}
  retrieves tx variable name. Uses method defined for TxInfoFactor objects.

\code{.validTx(object, txVec)}
  ensures all elements in txVec are allowed by superset.
}
\keyword{internal}
