% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gVIMP.R
\name{plot_gVIMP}
\alias{plot_gVIMP}
\title{Compute the grouped-VIMP statistic}
\usage{
plot_gVIMP(DynForest_obj, PCT = FALSE)
}
\arguments{
\item{DynForest_obj}{\code{DynForest} object}

\item{PCT}{Display VIMP statistic in pourcentage. Default value is FALSE.}
}
\value{
Display the grouped-VIMP for each given group
}
\description{
Compute the grouped-VIMP statistic
}
\examples{
\donttest{
data(pbc2)

# Sample 100 subjects
set.seed(1234)
id <- unique(pbc2$id)
id_sample <- sample(id, 100)
id_row <- which(pbc2$id\%in\%id_sample)

pbc2_train <- pbc2[id_row,]

timeData_train <- pbc2_train[,c("id","time",
                                "serBilir","SGOT",
                                "albumin","alkaline")]

# Create object with longitudinal association for each predictor
timeVarModel <- list(serBilir = list(fixed = serBilir ~ time,
                                     random = ~ time),
                     SGOT = list(fixed = SGOT ~ time + I(time^2),
                                 random = ~ time + I(time^2)),
                     albumin = list(fixed = albumin ~ time,
                                    random = ~ time),
                     alkaline = list(fixed = alkaline ~ time,
                                     random = ~ time))

# Build fixed data
fixedData_train <- unique(pbc2_train[,c("id","age","drug","sex")])

# Build outcome data
Y <- list(type = "surv",
          Y = unique(pbc2_train[,c("id","years","event")]))

# Run DynForest function
res_dyn <- DynForest(timeData = timeData_train, fixedData = fixedData_train,
                     timeVar = "time", idVar = "id",
                     timeVarModel = timeVarModel, Y = Y,
                     ntree = 50, nodesize = 5, minsplit = 5,
                     cause = 2, ncores = 2, seed = 1234)

# Compute OOB error
res_dyn_OOB <- compute_OOBerror(DynForest_obj = res_dyn, ncores = 2)

# Compute gVIMP statistic
res_dyn_gVIMP <- compute_gVIMP(DynForest_obj = res_dyn_OOB,
                               group = list(group1 = c("serBilir","SGOT"),
                                            group2 = c("albumin","alkaline")))

# Plot gVIMP
plot_gVIMP(res_dyn_gVIMP)

}
}
\seealso{
\code{\link{DynForest} \link{compute_gVIMP} \link{compute_VIMP} \link{plot_VIMP} \link{plot_mindepth}}
}
