% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableProportionOfPatientsCovered}
\alias{tableProportionOfPatientsCovered}
\title{Create a table with proportion of patients covered results}
\usage{
tableProportionOfPatientsCovered(
  result,
  header = c("cohort_name", strataColumns(result)),
  groupColumn = "cdm_name",
  type = "gt",
  hide = c("variable_name", "variable_level", "cohort_table_name"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{header}{Columns to use as header. See options with
\code{availableTableColumns(result)}.}

\item{groupColumn}{Columns to group by. See options with
\code{availableTableColumns(result)}.}

\item{type}{Type of table. Check supported types with
\code{visOmopResults::tableType()}.}

\item{hide}{Columns to hide from the visualisation. See options with
\code{availableTableColumns(result)}.}

\item{.options}{A named list with additional formatting options.
\code{visOmopResults::tableOptions()} shows allowed arguments and their default
values.}
}
\value{
A table with a formatted version of summariseProportionOfPatientsCovered() results.
}
\description{
Create a table with proportion of patients covered results
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

cdm <- generateDrugUtilisationCohortSet(cdm = cdm,
                                        name = "my_cohort",
                                        conceptSet = list(drug_of_interest = c(1503297, 1503327)))

result <- cdm$my_cohort |>
  summariseProportionOfPatientsCovered(followUpDays = 365)

tableProportionOfPatientsCovered(result)
}

}
