% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateDrugUtilisationCohortSet.R
\name{generateDrugUtilisationCohortSet}
\alias{generateDrugUtilisationCohortSet}
\title{Generates a cohort of the drug use of a certain list of concepts.}
\usage{
generateDrugUtilisationCohortSet(
  cdm,
  name,
  conceptSetList,
  summariseMode = "AllEras",
  fixedTime = NULL,
  daysPriorHistory = 0,
  gapEra = 30,
  priorUseWashout = 0,
  cohortDateRange = as.Date(c(NA, NA)),
  imputeDuration = "eliminate",
  durationRange = c(1, Inf)
)
}
\arguments{
\item{cdm}{A cdm_reference object.}

\item{name}{Name of the GeneratedCohortSet}

\item{conceptSetList}{Named list of concept sets.}

\item{summariseMode}{Choice on how to summarize the exposures. There are
three options:
"FixedTime" each individual is followed the exact same number of days
specified in 'fixedTime' argument.
"AllEras" we summarize the output will be a summary of the exposed eras of
each individual. Each individual can contribute multiple times.
"FirstEra" we only consider the first observable era of each individual. In
this case each individual can not contribute with multiple rows.
By default: "AllEras".}

\item{fixedTime}{Time period after first exposure where we summarize the
ingredient of interest. Argument only considered if 'summariseMode' =
"FixedTime". No default value is provided.}

\item{daysPriorHistory}{Minimum number of days of prior history
(observation time) required for the incident eras to be considered. By
default: 0, meaning it has to be in observation_period table.
When Null, we do not check if in observation_period table.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era. By default: 180.}

\item{priorUseWashout}{Prior days without exposure. By default: NULL.}

\item{cohortDateRange}{Range for cohort_start_date and cohort_end_date}

\item{imputeDuration}{Whether/how the duration should be imputed
"eliminate", "median", "mean", "quantile25", "quantile75".}

\item{durationRange}{Range between the duration must be comprised. It should
be a numeric vector of length two, with no NAs and the first value should be
equal or smaller than the second one. It is only required if imputeDuration
= TRUE. If NULL no restrictions are applied. By default: NULL.}
}
\value{
The function returns the 'cdm' object with the created tables as
references of the object.
}
\description{
Generates a cohort of the drug use of a certain list of concepts.
}
\examples{
\donttest{
#' library(DrugUtilisation)
library(CodelistGenerator)
library(CDMConnector)

cdm <- mockDrugUtilisation()

druglist <- getDrugIngredientCodes(cdm, c("acetaminophen", "metformin"))

cdm <- generateDrugUtilisationCohortSet(
  cdm = cdm,
  name = "drug_cohorts",
  conceptSetList = druglist,
  daysPriorHistory = 365
)

cdm$drug_cohorts

cohortSet(cdm$drug_cohorts)

cohortCount(cdm$drug_cohorts)

cohortAttrition(cdm$drug_cohorts)
}

}
