% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R, R/load.R
\name{setCollectionDirectory}
\alias{setCollectionDirectory}
\alias{setDirectories}
\alias{setDataDirectory}
\title{This function initializes the paths to data files.}
\usage{
setCollectionDirectory(
  collectionDirectory = file.path(getOption("qd.datadir"), "collections")
)

setDirectories(
  dataDirectory = file.path(path.expand("~"), "QuaDramA", "Data2"),
  collectionDirectory = file.path(dataDirectory, "collections")
)

setDataDirectory(
  dataDirectory = file.path(path.expand("~"), "QuaDramA", "Data2")
)
}
\arguments{
\item{collectionDirectory}{A path to the directory in which collections are stored. 
By default, the directory is called "collection" below the data directory.}

\item{dataDirectory}{A path to the directory in which data and metadata are located. 
"~/QuaDramA/Data2" by default.}
}
\value{
The \code{set*Directory()} functions always return \code{NULL}.
}
\description{
This function initializes the paths to data files.
}
